/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modobserver.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.sn0wix_.modobserver.ModObserver;
import net.sn0wix_.modobserver.detection.ModEntry;
import net.sn0wix_.modobserver.detection.Utils;
import net.sn0wix_.modobserver.screen.gui.CheckboxWidget;

public class ConfigGeneratorScreen
extends class_437 {
    private final class_8667 grid = class_8667.method_52741().method_52735(10);
    public final class_8132 layout = new class_8132((class_437)this, 43, 70);
    private final class_437 parent;
    private CheckboxWidget modmenuWidget;
    private CheckboxWidget childrenWidget;
    private CheckboxWidget fabricApiWidget;
    private CheckboxWidget hashesWidget;

    public ConfigGeneratorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.mod_observer.config_generator"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.initHeader();
        this.initBody();
        this.initFooter();
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    protected void initHeader() {
        class_8667 column = class_8667.method_52741();
        column.method_52736((class_8021)new class_7842(this.field_22793.method_27525((class_5348)this.field_22785), 9, this.field_22785, this.field_22793).method_48597());
        this.layout.method_48992((class_8021)column);
    }

    protected void initBody() {
        this.modmenuWidget = new CheckboxWidget.Builder((class_2561)class_2561.method_43471((String)"text.mod_observer.include.modmenu"), this.field_22793).build();
        this.childrenWidget = new CheckboxWidget.Builder((class_2561)class_2561.method_43471((String)"text.mod_observer.include.children"), this.field_22793).build();
        this.fabricApiWidget = new CheckboxWidget.Builder((class_2561)class_2561.method_43471((String)"text.mod_observer.include.fabric_api"), this.field_22793).build();
        this.hashesWidget = new CheckboxWidget.Builder((class_2561)class_2561.method_43471((String)"text.mod_observer.include.hashes"), this.field_22793).build();
        this.modmenuWidget.method_25306();
        this.childrenWidget.method_25306();
        this.fabricApiWidget.method_25306();
        this.hashesWidget.method_25306();
        this.grid.method_52736((class_8021)this.modmenuWidget);
        this.grid.method_52736((class_8021)this.hashesWidget);
        this.grid.method_52736((class_8021)this.childrenWidget);
        this.grid.method_52736((class_8021)this.fabricApiWidget);
        this.layout.method_48999((class_8021)this.grid);
    }

    protected void initFooter() {
        class_8667 layoutWidget = class_8667.method_52741().method_52735(2);
        layoutWidget.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.mod_observer.generate_config"), button -> {
            Object dateTime = String.valueOf(LocalDate.now()) + "T" + String.valueOf(LocalTime.now().truncatedTo(ChronoUnit.SECONDS));
            dateTime = ((String)dateTime).replace(":", "_").replace("-", "_");
            File file = new File("config/mod_observer/" + (String)dateTime + ".json");
            try {
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                FileWriter writer = new FileWriter(file);
                LinkedHashMap<ModEntry, Object> map = Utils.getModsList();
                Iterator<Map.Entry<ModEntry, Object>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<ModEntry, Object> entry = iterator.next();
                    if (!this.includeFabricApi() && Utils.isFabricApi(entry.getKey().getId()) || !this.includeModMenu() && entry.getKey().getId().equals("modmenu")) {
                        iterator.remove();
                    }
                    if (!this.includeHashes() && !entry.getKey().getHash().isEmpty()) {
                        entry.getKey().removeHash();
                    }
                    if (this.includeChildren()) continue;
                    entry.setValue(Map.of());
                }
                writer.write(Utils.toJson(map));
                writer.close();
                class_156.method_668().method_672(file.getParentFile());
            }
            catch (IOException e) {
                ModObserver.LOGGER.error("Failed to create config file: ", (Throwable)e);
            }
        }).method_46437(200, 20).method_46431());
        layoutWidget.method_52736((class_8021)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.back"), button -> this.field_22787.method_1507(this.parent)).method_46437(200, 20).method_46431());
        this.layout.method_48996((class_8021)layoutWidget);
    }

    public boolean includeChildren() {
        return this.childrenWidget.isChecked();
    }

    public boolean includeHashes() {
        return this.hashesWidget.isChecked();
    }

    public boolean includeModMenu() {
        return this.modmenuWidget.isChecked();
    }

    public boolean includeFabricApi() {
        return this.fabricApiWidget.isChecked();
    }

    protected void method_48640() {
        class_7843.method_48634((class_8021)this.grid, (class_8030)this.method_48202());
        this.layout.method_48222();
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

