/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modobserver.screen.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CheckboxWidget
extends class_4264 {
    private static final class_2960 SELECTED_HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"widget/checkbox_selected_highlighted");
    private static final class_2960 SELECTED_TEXTURE = class_2960.method_60656((String)"widget/checkbox_selected");
    private static final class_2960 HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"widget/checkbox_highlighted");
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"widget/checkbox");
    private static final int TEXT_COLOR = -2039584;
    private static final int field_47105 = 4;
    private static final int field_47106 = 8;
    private boolean checked;
    private final Callback callback;
    private final class_7940 textWidget;

    private CheckboxWidget(int x, int y, int maxWidth, class_2561 message, class_327 textRenderer, boolean checked, Callback callback) {
        super(x, y, 0, 0, message);
        this.field_22758 = this.calculateWidth(maxWidth, message, textRenderer);
        this.textWidget = new class_7940(message, textRenderer).method_48984(this.field_22758).method_48983(-2039584);
        this.field_22759 = this.calculateHeight(textRenderer);
        this.checked = checked;
        this.callback = callback;
    }

    private int calculateWidth(int max, class_2561 text, class_327 textRenderer) {
        return Math.min(CheckboxWidget.calculateWidth(text, textRenderer), max);
    }

    private int calculateHeight(class_327 textRenderer) {
        return Math.max(CheckboxWidget.getCheckboxSize(textRenderer), this.textWidget.method_25364());
    }

    static int calculateWidth(class_2561 text, class_327 textRenderer) {
        return CheckboxWidget.getCheckboxSize(textRenderer) + 4 + textRenderer.method_27525((class_5348)text);
    }

    public static Builder builder(class_2561 text, class_327 textRenderer) {
        return new Builder(text, textRenderer);
    }

    public static int getCheckboxSize(class_327 textRenderer) {
        return 17;
    }

    public void method_25306() {
        this.checked = !this.checked;
        this.callback.onValueChange(this, this.checked);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.checkbox.usage.focused"));
            } else {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        class_310 minecraftClient = class_310.method_1551();
        class_327 textRenderer = minecraftClient.field_1772;
        class_2960 identifier = this.checked ? (this.method_25370() ? SELECTED_HIGHLIGHTED_TEXTURE : SELECTED_TEXTURE) : (this.method_25370() ? HIGHLIGHTED_TEXTURE : TEXTURE);
        int i = CheckboxWidget.getCheckboxSize(textRenderer);
        context.method_52706(class_10799.field_56883, identifier, this.method_46426(), this.method_46427(), i, i);
        int j = this.method_46426() + i + 4;
        int k = this.method_46427() + i / 2 - this.textWidget.method_25364() / 2;
        this.textWidget.method_48229(j, k);
        this.textWidget.method_48579(context, mouseX, mouseY, deltaTicks);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Callback {
        public static final Callback EMPTY = (checkbox, checked) -> {};

        public void onValueChange(CheckboxWidget var1, boolean var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        private final class_2561 message;
        private final class_327 textRenderer;
        private int maxWidth;
        private int x = 0;
        private int y = 0;
        private Callback callback = Callback.EMPTY;
        private boolean checked = false;
        @Nullable
        private class_7172<Boolean> option = null;
        @Nullable
        private class_7919 tooltip = null;

        public Builder(class_2561 message, class_327 textRenderer) {
            this.message = message;
            this.textRenderer = textRenderer;
            this.maxWidth = CheckboxWidget.calculateWidth(message, textRenderer);
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder callback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Builder checked(boolean checked) {
            this.checked = checked;
            this.option = null;
            return this;
        }

        public Builder option(class_7172<Boolean> option) {
            this.option = option;
            this.checked = (Boolean)option.method_41753();
            return this;
        }

        public Builder tooltip(class_7919 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder maxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public CheckboxWidget build() {
            Callback callback = this.option == null ? this.callback : (checkbox, checked) -> {
                this.option.method_41748((Object)checked);
                this.callback.onValueChange(checkbox, checked);
            };
            CheckboxWidget checkboxWidget = new CheckboxWidget(this.x, this.y, this.maxWidth, this.message, this.textRenderer, this.checked, callback);
            checkboxWidget.method_47400(this.tooltip);
            return checkboxWidget;
        }
    }
}

