/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modobserver.screen.gui;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.sn0wix_.modobserver.ModObserver;
import net.sn0wix_.modobserver.compat.ModMenuCompat;
import net.sn0wix_.modobserver.detection.IllegalStates;
import net.sn0wix_.modobserver.screen.ModsScreen;

public class ModsListWidget
extends class_4265<Entry> {
    private int maxKeyNameLength;

    public ModsListWidget(ModsScreen parent, class_310 client) {
        super(client, parent.field_22789, parent.layout.method_57727(), parent.layout.method_48998(), 20);
        parent.detectedOn.forEach((illegalState, modids) -> {
            this.method_25321((class_350.class_351)new TitleEntry(this, (IllegalStates)((Object)illegalState)));
            modids.forEach(modid -> {
                Optional<ModContainer> modContainerOptional = FabricLoader.getInstance().getAllMods().stream().filter(modContainer -> modContainer.getMetadata().getId().equals(modid)).findAny();
                ModsScreen.Container container = modContainerOptional.map(ModsScreen.Container::new).orElseGet(() -> new ModsScreen.Container((String)modid, (String)modid, "", ""));
                int i = client.field_1772.method_27525((class_5348)class_2561.method_43470((String)modid));
                if (i > this.maxKeyNameLength) {
                    this.maxKeyNameLength = i;
                }
                this.method_25321((class_350.class_351)new ModEntry(container, parent));
            });
        });
        if (this.maxKeyNameLength < this.method_25368() / 3) {
            this.maxKeyNameLength = this.method_25368() / 3;
        }
    }

    public int method_25322() {
        return this.method_25368();
    }

    protected int method_65507() {
        return this.method_46426() + this.field_22758 / 2 - 170 + 340 + 10;
    }

    public class TitleEntry
    extends Entry {
        private final class_7842 title;

        public TitleEntry(final ModsListWidget this$0, IllegalStates state) {
            this.title = new class_7842(this, state.getTranslation(), ((ModsListWidget)this$0).field_22740.field_1772){

                public boolean method_25402(class_11909 click, boolean doubled) {
                    return false;
                }
            };
            this.title.method_47400(state.getTooltip());
            this.title.method_46438(-256);
            this.title.field_22763 = true;
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.title);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.title);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.title.method_48229(this.method_73387() / 2 - this.title.method_25368() / 2, this.method_73382() + this.method_73384() / 2 - 4);
            this.title.method_25394(context, mouseX, mouseY, deltaTicks);
        }
    }

    public class ModEntry
    extends Entry {
        class_2960 iconLocation;
        private final ModsScreen.Container container;
        private final class_4185 issuesButton;
        private final class_4185 homepageButton;
        private class_7842 name;

        public ModEntry(ModsScreen.Container container, ModsScreen parent) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            this.container = container;
            this.issuesButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.mod_observer.issue_tracker"), (class_4185.class_4241)class_407.method_61038((class_437)parent, (URI)container.getIssues(), (boolean)false)).method_46437(textRenderer.method_27525((class_5348)class_2561.method_43471((String)"text.mod_observer.issue_tracker")) + 8, 20).method_46431();
            this.homepageButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.mod_observer.homepage"), (class_4185.class_4241)class_407.method_61038((class_437)parent, (URI)container.getHomepage(), (boolean)false)).method_46437(textRenderer.method_27525((class_5348)class_2561.method_43471((String)"text.mod_observer.homepage")) + 8, 20).method_46431();
            final Optional modContainer = FabricLoader.getInstance().getModContainer(container.modid());
            try {
                Path path = (Path)((ModContainer)modContainer.get()).getOrigin().getPaths().getFirst();
                this.name = new class_7842(this, (class_2561)class_2561.method_43470((String)container.name()), textRenderer){

                    public void method_25348(class_11909 click, boolean doubled) {
                        try {
                            class_156.method_668().method_60932(((Path)((ModContainer)modContainer.get()).getOrigin().getPaths().getFirst()).getParent());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.name.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)path.getFileName().toString())));
                this.name.field_22763 = true;
            }
            catch (Exception e) {
                this.name = new class_7842((class_2561)class_2561.method_43470((String)container.name()), textRenderer);
                this.name.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)("Mod ID: " + container.modid()))));
            }
            this.issuesButton.field_22763 = !container.getIssues().toString().isEmpty();
            this.homepageButton.field_22763 = !container.getHomepage().toString().isEmpty();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)ModEntry.this.container.name()));
                }
            });
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.issuesButton, this.homepageButton, this.name);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int resetButtonPos = ModsListWidget.this.method_65507() - this.issuesButton.method_25368() - 8;
            int j = this.method_73382() - 2;
            int startPos = this.method_25368() / 2 - ModsListWidget.this.maxKeyNameLength;
            if (startPos < 10) {
                startPos = 10;
            }
            this.name.method_48229(startPos + (ModObserver.HAS_MODMENU ? 25 : 0), this.method_73382() + this.method_73384() / 2 - 4);
            this.name.method_25394(context, mouseX, mouseY, deltaTicks);
            if (ModObserver.HAS_MODMENU) {
                context.method_25290(class_10799.field_56883, this.getIconTexture(), startPos, this.method_73382(), 0.0f, 0.0f, 20, 20, 20, 20);
            }
            this.issuesButton.method_48229(resetButtonPos, j);
            this.issuesButton.method_25394(context, mouseX, mouseY, deltaTicks);
            int editButtonPos = resetButtonPos - 8 - this.homepageButton.method_25368();
            this.homepageButton.method_48229(editButtonPos, j);
            this.homepageButton.method_25394(context, mouseX, mouseY, deltaTicks);
        }

        public class_2960 getIconTexture() {
            if (ModObserver.HAS_MODMENU) {
                if (this.iconLocation == null) {
                    this.iconLocation = class_2960.method_60655((String)"mod_observer", (String)(this.container.modid() + "_icon"));
                    class_1043 icon = ModMenuCompat.getIconImage(this.container.modid());
                    icon.method_4527(false, false);
                    class_310.method_1551().method_1531().method_4616(this.iconLocation, (class_1044)icon);
                }
                return this.iconLocation;
            }
            return null;
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

