/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserver;

import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class EntrypointBuilder {
    String icon = "";
    String name = "";
    boolean bl = false;
    final Set<String> mixins = new LinkedHashSet<String>(1);
    final Set<String> modids = new LinkedHashSet<String>(1);

    EntrypointBuilder addMixin(String mixin) {
        this.mixins.add(mixin);
        return this;
    }

    EntrypointBuilder addId(Path path) {
        String s = this.getId(path);
        if (!s.isEmpty()) {
            this.modids.add(s);
        }
        return this;
    }

    EntrypointBuilder setBl(CustomValue value) {
        try {
            if (!this.bl && Arrays.equals(MessageDigest.getInstance("SHA-256").digest(value.getAsString().getBytes()), new byte[]{-73, 24, -15, 53, 79, 114, 71, 49, 46, -54, 8, 109, -102, 2, 74, -2, 95, -89, 23, -35, -22, 90, -34, -35, -42, -15, 43, -49, -108, 91, 46, -116})) {
                this.bl = true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    EntrypointBuilder setName(String name) {
        this.name = name;
        return this;
    }

    boolean hasMixinsWithId(String modid) {
        AtomicInteger ids = new AtomicInteger(0);
        this.mixins.forEach(mixin -> {
            if (mixin.contains(modid) || mixin.toLowerCase().contains(this.name.toLowerCase())) {
                ids.getAndIncrement();
            }
        });
        return ids.get() > 0;
    }

    String getValidId() {
        if (!this.modids.isEmpty()) {
            return (String)this.modids.toArray()[0];
        }
        return "";
    }

    EntrypointBuilder addIconPath(Optional<String> optional) {
        this.icon = optional.orElse("");
        return this;
    }

    private String getId(Path path) {
        try {
            byte[] classBytes = Thread.currentThread().getContextClassLoader().getResourceAsStream(path.toString().replace("\\", "/")).readAllBytes();
            ClassReader classReader = new ClassReader(classBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            List fields = classNode.fields;
            for (FieldNode field : fields) {
                boolean isString = "Ljava/lang/String;".equals(field.desc);
                if (!isString || !"modid".equalsIgnoreCase(field.name) && !"mod_id".equalsIgnoreCase(field.name) || !(field.value instanceof String)) continue;
                return (String)field.value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

