/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap;

import java.util.List;
import me.imagemap.commands.AutoTabCompleter;
import me.imagemap.commands.CommandManager;
import me.imagemap.data.ImageManager;
import me.imagemap.data.Locale;
import me.imagemap.database.Database;
import me.imagemap.listeners.PlayerCurrencyInitializeOnJoinListener;
import me.imagemap.utils.LanguageConfig;
import me.imagemap.utils.Metrics;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class ImageMap
extends JavaPlugin {
    public static Economy economy;
    public static Boolean hasVault;
    public static ImageMap plugin;
    public static List<String> domainWhitelist;
    public static boolean useWhitelist;
    public static String connectionURL;
    public static int defaultTokenAmount;
    public static String BOT_TOKEN;
    public static String CHANNEL_ID;
    public static JDA jda;
    public static boolean isDiscordEnabled;

    public void onEnable() {
        plugin = this;
        this.initializeConfig();
        this.initializeLang();
        this.setupDatabase();
        domainWhitelist = this.getConfig().getStringList("whitelisted-domains");
        useWhitelist = this.getConfig().getBoolean("use-whitelist");
        defaultTokenAmount = this.getConfig().getInt("image-tokens.default");
        isDiscordEnabled = this.getConfig().getBoolean("bot-settings.enabled");
        if (isDiscordEnabled) {
            BOT_TOKEN = this.getConfig().getString("bot-settings.token");
            CHANNEL_ID = this.getConfig().getString("bot-settings.channel-id");
            jda = JDABuilder.createDefault(BOT_TOKEN).build();
        }
        Metrics metrics = new Metrics((Plugin)this, 19395);
        if (plugin.getConfig().getBoolean("use-economy") && !this.setupEconomy()) {
            this.getLogger().severe("Vault dependency not found! Disabling economy support.");
            Bukkit.getLogger().info(String.valueOf(hasVault));
            hasVault = false;
            Bukkit.getLogger().info(String.valueOf(hasVault));
        }
        ImageManager manager = ImageManager.getInstance();
        manager.init();
        this.getCommand("im").setExecutor((CommandExecutor)new CommandManager());
        this.getCommand("im").setTabCompleter((TabCompleter)new AutoTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCurrencyInitializeOnJoinListener(), (Plugin)this);
    }

    private void initializeConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
    }

    private void initializeLang() {
        LanguageConfig.setupLang();
        for (Locale localeMessage : Locale.values()) {
            LanguageConfig.getLangConfig().addDefault(localeMessage.toString(), (Object)this.getConfig().getString(String.valueOf((Object)localeMessage)));
        }
        LanguageConfig.getLangConfig().options().copyDefaults(true);
        LanguageConfig.saveLangConfig();
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return economy != null;
    }

    private void setupDatabase() {
        if (plugin.getConfig().getString("database").equalsIgnoreCase("mysql")) {
            String host = plugin.getConfig().getString("mysql-settings.host");
            String dbName = plugin.getConfig().getString("mysql-settings.db-name");
            String port = plugin.getConfig().getString("mysql-settings.port");
            String username = plugin.getConfig().getString("mysql-settings.username");
            String password = plugin.getConfig().getString("mysql-settings.password");
            connectionURL = "jdbc:mysql://" + username + ":" + password + "@" + host + ":" + port + "/" + dbName;
        } else if (plugin.getConfig().getString("database").equalsIgnoreCase("h2")) {
            connectionURL = "jdbc:h2:file:" + this.getDataFolder().getAbsolutePath() + "/currency/currency-data";
        } else {
            Bukkit.getLogger().severe("[ImageMapPlus] Invalid database type! Please choose either \"mysql\" or \"h2\"");
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
        Database.initializeDatabase();
    }

    public static Economy getEconomy() {
        return economy;
    }

    static {
        hasVault = true;
    }
}

