/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.commands;

import java.util.ArrayList;
import me.imagemap.ImageMap;
import me.imagemap.commands.SubCommand;
import me.imagemap.commands.subcommands.CreateCommand;
import me.imagemap.commands.subcommands.HelpCommand;
import me.imagemap.commands.subcommands.ReloadCommand;
import me.imagemap.commands.subcommands.tokens.GiveTokenCommand;
import me.imagemap.commands.subcommands.tokens.ResetTokenCommand;
import me.imagemap.commands.subcommands.tokens.TakeTokenCommand;
import me.imagemap.commands.subcommands.tokens.TokenBalanceCommand;
import me.imagemap.data.Locale;
import me.imagemap.utils.LanguageConfig;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor {
    private ArrayList<SubCommand> subcommands = new ArrayList();

    public CommandManager() {
        this.subcommands.add(new HelpCommand());
        this.subcommands.add(new ReloadCommand());
        this.subcommands.add(new CreateCommand());
        this.subcommands.add(new GiveTokenCommand());
        this.subcommands.add(new ResetTokenCommand());
        this.subcommands.add(new TakeTokenCommand());
        this.subcommands.add(new TokenBalanceCommand());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        FileConfiguration lang = LanguageConfig.getLangConfig();
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)ImageMap.plugin.getConfig().getString("prefix"));
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (args2.length == 0) {
                HelpCommand help = new HelpCommand();
                help.perform(p, args2);
            } else if (args2.length > 0) {
                boolean isValidSubcommand = false;
                for (int i = 0; i < this.getSubCommands().size(); ++i) {
                    if (!args2[0].equalsIgnoreCase(this.getSubCommands().get(i).getName())) continue;
                    isValidSubcommand = true;
                    if (p.hasPermission(this.getSubCommands().get(i).getPermissionNode())) {
                        this.getSubCommands().get(i).perform(p, args2);
                        break;
                    }
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfig.getLangConfig().getString(Locale.getLocale(Locale.NO_PERMISSION_FOR_COMMAND))));
                    break;
                }
                if (!isValidSubcommand) {
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)lang.getString(Locale.getLocale(Locale.INVALID_COMMAND))));
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)lang.getString(Locale.getLocale(Locale.HELP_SUGGESTION))));
                }
                return true;
            }
        }
        return true;
    }

    public ArrayList<SubCommand> getSubCommands() {
        return this.subcommands;
    }
}

