/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.commands;

import java.util.List;
import me.imagemap.ImageMap;
import me.imagemap.data.ImageManager;
import me.imagemap.models.LogoRenderer;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.RegisteredServiceProvider;

public class ImageCommand
implements CommandExecutor {
    Economy economy;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args2) {
        if (args2[0].equalsIgnoreCase("reload") && sender.hasPermission("imagemap.reload")) {
            try {
                ImageMap.plugin.reloadConfig();
                sender.sendMessage(ChatColor.GOLD + "[IM] Configuration reloaded successfully.");
                return true;
            }
            catch (Exception ex) {
                System.out.println(ex);
                sender.sendMessage(ChatColor.DARK_RED + "[IM] Failed to reload config! Check console for details.");
                return true;
            }
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "[IM] Console cannot use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("imagemap.create")) {
            player.sendMessage(ChatColor.DARK_RED + "[IM] Insufficient Permission!");
            return true;
        }
        if (args2.length == 0) {
            player.sendMessage(ChatColor.DARK_RED + "[IM] Wrong Usage. Please use /im <link>");
            return true;
        }
        if (this.hasBlacklistedWords(args2)) {
            sender.sendMessage(ChatColor.DARK_RED + "[IM] Command contains blacklisted words!");
            return true;
        }
        MapView view = Bukkit.createMap((World)player.getWorld());
        view.getRenderers().clear();
        LogoRenderer renderer = new LogoRenderer();
        if (!renderer.Load(args2[0])) {
            player.sendMessage(ChatColor.DARK_RED + "[IM] Image not found!");
            return true;
        }
        if (ImageMap.plugin.getConfig().getBoolean("paid-map-generation")) {
            if (ImageMap.plugin.getConfig().getBoolean("economy.enabled")) {
                this.setupEconomy();
                double cost = ImageMap.plugin.getConfig().getInt("economy.amount");
                if (!this.reducePlayerBalance(player, cost)) {
                    player.sendMessage(ChatColor.DARK_RED + "[IM] Insufficient funds!");
                    return true;
                }
                player.sendMessage(ChatColor.GOLD + "[IM] You have purchased the 1x Image Map for $" + cost);
            } else {
                String itemString = ImageMap.plugin.getConfig().getString("vanilla.item", "DIAMOND");
                Material itemType = Material.matchMaterial((String)itemString);
                int quantity = ImageMap.plugin.getConfig().getInt("vanilla.amount");
                if (itemType == null) {
                    Bukkit.getLogger().severe("Invalid item specified in the configuration.");
                    return true;
                }
                if (!this.deductItem(player, itemType, quantity)) {
                    player.sendMessage(ChatColor.DARK_RED + "[IM] Insufficient items!");
                    return false;
                }
                player.sendMessage(ChatColor.GOLD + "[IM] You have purchased 1x Image Map for " + quantity + " " + itemType.toString() + ".");
            }
        }
        view.addRenderer((MapRenderer)renderer);
        ItemStack map = new ItemStack(Material.FILLED_MAP);
        MapMeta meta = (MapMeta)map.getItemMeta();
        meta.setMapView(view);
        map.setItemMeta((ItemMeta)meta);
        player.getInventory().addItem(new ItemStack[]{map});
        player.sendMessage(ChatColor.AQUA + "[IM] Map creation successful!");
        ImageManager manager = ImageManager.getInstance();
        manager.saveImage(view.getId(), args2[0]);
        return false;
    }

    private boolean deducer(Player player) {
        return false;
    }

    private boolean setupEconomy() {
        if (ImageMap.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = ImageMap.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    private double getPlayerBalance(Player player) {
        if (this.economy == null) {
            ImageMap.plugin.getLogger().warning("Economy instance is null. Cannot check player balance.");
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    private boolean reducePlayerBalance(Player player, double amount) {
        if (this.economy == null) {
            ImageMap.plugin.getLogger().warning("Economy instance is null. Cannot reduce player balance.");
            return false;
        }
        if (this.economy.getBalance((OfflinePlayer)player) < amount) {
            return false;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        return true;
    }

    private boolean deductItem(Player player, Material itemType, int quantity) {
        ItemStack itemStack = new ItemStack(itemType, quantity);
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != itemType) continue;
            if (item.getAmount() >= quantity) {
                item.setAmount(item.getAmount() - quantity);
                player.updateInventory();
                return true;
            }
            count += item.getAmount();
        }
        if (count >= quantity) {
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != itemType) continue;
                int currentAmount = item.getAmount();
                if (currentAmount >= quantity) {
                    item.setAmount(currentAmount - quantity);
                    player.updateInventory();
                    return true;
                }
                player.getInventory().remove(item);
                quantity -= currentAmount;
            }
        }
        return false;
    }

    private boolean hasBlacklistedWords(String[] args2) {
        List blacklistedWords = ImageMap.plugin.getConfig().getStringList("blacklisted-words");
        for (String word : args2) {
            for (String blacklistedWord : blacklistedWords) {
                if (!word.toLowerCase().contains(blacklistedWord.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

