/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.commands.subcommands;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import me.imagemap.ImageMap;
import me.imagemap.bot.SendCreationMessage;
import me.imagemap.commands.SubCommand;
import me.imagemap.data.ImageManager;
import me.imagemap.data.Locale;
import me.imagemap.database.Database;
import me.imagemap.models.LogoRenderer;
import me.imagemap.utils.LanguageConfig;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.RegisteredServiceProvider;

public class CreateCommand
extends SubCommand {
    FileConfiguration lang = LanguageConfig.getLangConfig();
    String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)ImageMap.plugin.getConfig().getString("prefix"));
    Economy economy;

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String getDescription() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.CREATE_COMMAND_DESCRIPTION)));
    }

    @Override
    public String getSyntax() {
        return "/im create <link>";
    }

    @Override
    public String getPermissionNode() {
        return "imagemap.create";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void perform(Player p, String[] args2) {
        if (!p.hasPermission("imagemap.create")) {
            p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.NO_PERMISSION_FOR_COMMAND))));
            return;
        }
        if (ImageMap.useWhitelist) {
            if (!CreateCommand.isLinkAllowed(args2[1])) {
                p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.NOT_WHITELISTED_LINK))));
                return;
            }
        } else if (this.hasBlacklistedWords(args2)) {
            p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.BLACKLISTED_WORD_IN_LINK))));
            return;
        }
        MapView view = Bukkit.createMap((World)p.getWorld());
        view.getRenderers().clear();
        LogoRenderer renderer = new LogoRenderer();
        if (!renderer.Load(args2[1])) {
            p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.IMG_NOT_FOUND))));
            return;
        }
        if (ImageMap.plugin.getConfig().getBoolean("paid-map-generation")) {
            if (ImageMap.plugin.getConfig().getBoolean("economy.enabled")) {
                this.setupEconomy();
                double cost = ImageMap.plugin.getConfig().getInt("economy.amount");
                if (!this.reducePlayerBalance(p, cost)) {
                    p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.INSUFFICIENT_FUNDS))));
                    return;
                }
                p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.MAP_PURCHASE_SUCCESSFUL_MONEY))));
            } else if (ImageMap.plugin.getConfig().getBoolean("vanilla.enabled")) {
                String itemString = ImageMap.plugin.getConfig().getString("vanilla.item", "DIAMOND");
                Material itemType = Material.matchMaterial((String)itemString);
                int quantity = ImageMap.plugin.getConfig().getInt("vanilla.amount");
                if (itemType == null) {
                    Bukkit.getConsoleSender().sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.INVALID_ITEM_CONFIG))));
                    return;
                }
                if (!this.deductItem(p, itemType, quantity)) {
                    p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.INSUFFICIENT_ITEMS))));
                    return;
                }
                p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.MAP_PURCHASE_SUCCESSFUL_ITEMS))));
            } else if (ImageMap.plugin.getConfig().getBoolean("image-tokens.enabled")) {
                if (Integer.parseInt(Database.getCurrencyAmount(p.getUniqueId().toString())) < ImageMap.plugin.getConfig().getInt("image-tokens.amount")) {
                    p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.INSUFFICIENT_TOKENS))));
                    return;
                }
                UUID uuid = p.getUniqueId();
                int takeAmount = ImageMap.plugin.getConfig().getInt("image-tokens.amount");
                int prevAmount = Integer.parseInt(Database.getCurrencyAmount(uuid.toString()));
                Database.updateCurrency(prevAmount - takeAmount, uuid.toString());
                p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.MAP_PURCHASE_SUCCESSFUL_TOKENS))));
            }
        }
        view.addRenderer((MapRenderer)renderer);
        ItemStack map = new ItemStack(Material.FILLED_MAP);
        MapMeta meta = (MapMeta)map.getItemMeta();
        meta.setMapView(view);
        map.setItemMeta((ItemMeta)meta);
        p.getInventory().addItem(new ItemStack[]{map});
        p.sendMessage(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.MAP_CREATION_SUCCESSFUL))));
        ImageManager manager = ImageManager.getInstance();
        manager.saveImage(view.getId(), args2[1]);
        if (ImageMap.isDiscordEnabled) {
            SendCreationMessage.sendCreatedMap(p, args2[1]);
        }
    }

    private boolean setupEconomy() {
        if (ImageMap.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = ImageMap.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    private double getPlayerBalance(Player player) {
        if (this.economy == null) {
            ImageMap.plugin.getLogger().warning("Economy instance is null. Cannot check player balance.");
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    private boolean reducePlayerBalance(Player player, double amount) {
        if (this.economy == null) {
            ImageMap.plugin.getLogger().warning("Economy instance is null. Cannot reduce player balance.");
            return false;
        }
        if (this.economy.getBalance((OfflinePlayer)player) < amount) {
            return false;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        return true;
    }

    private boolean deductItem(Player player, Material itemType, int quantity) {
        ItemStack itemStack = new ItemStack(itemType, quantity);
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != itemType) continue;
            if (item.getAmount() >= quantity) {
                item.setAmount(item.getAmount() - quantity);
                player.updateInventory();
                return true;
            }
            count += item.getAmount();
        }
        if (count >= quantity) {
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != itemType) continue;
                int currentAmount = item.getAmount();
                if (currentAmount >= quantity) {
                    item.setAmount(currentAmount - quantity);
                    player.updateInventory();
                    return true;
                }
                player.getInventory().remove(item);
                quantity -= currentAmount;
            }
        }
        return false;
    }

    private boolean hasBlacklistedWords(String[] args2) {
        List blacklistedWords = ImageMap.plugin.getConfig().getStringList("blacklisted-words");
        for (String word : args2) {
            for (String blacklistedWord : blacklistedWords) {
                if (!word.toLowerCase().contains(blacklistedWord.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLinkAllowed(String link) {
        System.out.println("LINK: " + link);
        List<String> whitelist = ImageMap.domainWhitelist;
        try {
            URI uri = new URI(link);
            String domain = uri.getHost();
            System.out.println("DOMAIN: " + domain);
            if (domain != null) {
                domain = domain.startsWith("www.") ? domain.substring(4) : domain;
                domain = domain.toLowerCase();
                System.out.println(whitelist.toString());
                System.out.println("DOMAIN: " + domain);
                return whitelist.contains(domain);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return false;
    }
}

