/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.commands.subcommands.tokens;

import java.util.UUID;
import me.imagemap.commands.SubCommand;
import me.imagemap.data.Locale;
import me.imagemap.database.Database;
import me.imagemap.utils.LanguageConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class GiveTokenCommand
extends SubCommand {
    FileConfiguration lang = LanguageConfig.getLangConfig();

    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String getDescription() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.TOKEN_GIVE_DESCRIPTION)));
    }

    @Override
    public String getSyntax() {
        return "/im give <player> <amount>";
    }

    @Override
    public String getPermissionNode() {
        return "imagemap.token.manage";
    }

    @Override
    public void perform(Player p, String[] args2) {
        if (args2.length < 2) {
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args2[1]);
        if (target == null) {
            p.sendMessage(ChatColor.RED + "[IMP] Player " + ChatColor.YELLOW + args2[1] + ChatColor.RED + " not found!");
            return;
        }
        UUID uuid = target.getUniqueId();
        int giveAmount = Integer.parseInt(args2[2]);
        int prevAmount = Integer.parseInt(Database.getCurrencyAmount(uuid.toString()));
        System.out.println("Prev: " + prevAmount + " | Give: " + giveAmount);
        Database.updateCurrency(prevAmount + giveAmount, uuid.toString());
        p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[IMP] &9Gave&a " + giveAmount + " &9tokens to &e" + args2[1] + "&9. The player now has &a" + Integer.parseInt(Database.getCurrencyAmount(uuid.toString())) + " &9tokens")));
    }
}

