/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.commands.subcommands.tokens;

import java.util.UUID;
import me.imagemap.ImageMap;
import me.imagemap.commands.SubCommand;
import me.imagemap.data.Locale;
import me.imagemap.database.Database;
import me.imagemap.utils.LanguageConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ResetTokenCommand
extends SubCommand {
    FileConfiguration lang = LanguageConfig.getLangConfig();

    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public String getDescription() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.TOKEN_RESET_DESCRIPTION)));
    }

    @Override
    public String getSyntax() {
        return "/im reset <player>";
    }

    @Override
    public String getPermissionNode() {
        return "imagemap.token.manage";
    }

    @Override
    public void perform(Player p, String[] args2) {
        if (args2.length < 2) {
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args2[1]);
        if (target == null) {
            p.sendMessage(ChatColor.RED + "[IMP] Player " + ChatColor.YELLOW + args2[1] + ChatColor.RED + " not found!");
            return;
        }
        UUID uuid = target.getUniqueId();
        Database.updateCurrency(ImageMap.defaultTokenAmount, uuid.toString());
        p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[IMP] &9Reset tokens for player &e" + args2[1])));
    }
}

