/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.commands.subcommands.tokens;

import java.util.UUID;
import me.imagemap.commands.SubCommand;
import me.imagemap.data.Locale;
import me.imagemap.database.Database;
import me.imagemap.utils.LanguageConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TokenBalanceCommand
extends SubCommand {
    FileConfiguration lang = LanguageConfig.getLangConfig();

    @Override
    public String getName() {
        return "balance";
    }

    @Override
    public String getDescription() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.TOKEN_BALANCE_DESCRIPTION)));
    }

    @Override
    public String getSyntax() {
        return "/im balance [player]";
    }

    @Override
    public String getPermissionNode() {
        return "imagemap.token.viewself";
    }

    @Override
    public void perform(Player p, String[] args2) {
        if (args2.length == 2) {
            if (!p.hasPermission("imagemap.token.viewothers")) {
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.TOKEN_BALANCE_NO_PERM))));
                return;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args2[1]);
            if (target == null) {
                p.sendMessage(ChatColor.RED + "[IMP] Player " + ChatColor.YELLOW + args2[1] + ChatColor.RED + " not found!");
                return;
            }
            UUID uuid = target.getUniqueId();
            int otherBalance = Integer.parseInt(Database.getCurrencyAmount(uuid.toString()));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.TOKEN_BALANCE))) + otherBalance);
        } else {
            UUID uuid = p.getUniqueId();
            int otherBalance = Integer.parseInt(Database.getCurrencyAmount(uuid.toString()));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.lang.getString(Locale.getLocale(Locale.TOKEN_BALANCE))) + otherBalance);
        }
    }
}

