/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import me.imagemap.ImageMap;
import me.imagemap.models.LogoRenderer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class ImageManager
implements Listener {
    private static ImageManager instance = null;
    private CustomFile dataFile = new CustomFile("data.yml");
    private Map<Integer, String> savedImages = new HashMap<Integer, String>();

    public static ImageManager getInstance() {
        if (instance == null) {
            instance = new ImageManager();
        }
        return instance;
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ImageMap.getPlugin(ImageMap.class));
        this.loadImages();
    }

    @EventHandler
    public void onMapInitEvent(MapInitializeEvent event) {
        if (this.hasImage(event.getMap().getId())) {
            MapView view = event.getMap();
            view.getRenderers().clear();
            view.addRenderer((MapRenderer)new LogoRenderer(this.getImage(view.getId())));
            view.setScale(MapView.Scale.FARTHEST);
            view.setTrackingPosition(false);
        }
    }

    public void saveImage(Integer id, String url) {
        this.getData().set("ids." + id, (Object)url);
        this.saveData();
    }

    private void loadImages() {
        if (this.getData().contains("ids")) {
            this.getData().getConfigurationSection("ids").getKeys(false).forEach(id -> this.savedImages.put(Integer.parseInt(id), this.getData().getString("ids." + id)));
        }
    }

    public boolean hasImage(int id) {
        return this.savedImages.containsKey(id);
    }

    public String getImage(int id) {
        return this.savedImages.get(id);
    }

    public FileConfiguration getData() {
        return this.dataFile.getConfig();
    }

    public void saveData() {
        this.dataFile.saveConfig();
    }

    class CustomFile {
        private final ImageMap plugin = (ImageMap)ImageMap.getPlugin(ImageMap.class);
        private FileConfiguration dataConfig = null;
        private File dataConfigFile = null;
        private final String name;

        public CustomFile(String name) {
            this.name = name;
            this.saveDefaultConfig();
        }

        public void reloadConfig() {
            if (this.dataConfigFile == null) {
                this.dataConfigFile = new File(this.plugin.getDataFolder(), this.name);
            }
            this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataConfigFile);
            InputStream defConfigStream = this.plugin.getResource(this.name);
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
                this.dataConfig.setDefaults((Configuration)defConfig);
            }
        }

        public FileConfiguration getConfig() {
            if (this.dataConfig == null) {
                this.reloadConfig();
            }
            return this.dataConfig;
        }

        public void saveConfig() {
            if (this.dataConfig == null || this.dataConfigFile == null) {
                return;
            }
            try {
                this.getConfig().save(this.dataConfigFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.dataConfigFile, e);
            }
        }

        public void saveDefaultConfig() {
            if (this.dataConfigFile == null) {
                this.dataConfigFile = new File(this.plugin.getDataFolder(), this.name);
            }
            if (!this.dataConfigFile.exists()) {
                this.plugin.saveResource(this.name, false);
            }
        }
    }
}

