/*
 * Decompiled with CFR 0.152.
 */
package me.imagemap.utils;

import java.util.List;
import me.imagemap.ImageMap;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerUtils {
    static Economy economy = ImageMap.getEconomy();

    private double getPlayerBalance(Player player) {
        if (economy == null) {
            ImageMap.plugin.getLogger().warning("Economy instance is null. Cannot check player balance.");
            return 0.0;
        }
        return economy.getBalance((OfflinePlayer)player);
    }

    public static boolean reducePlayerBalance(Player player, double amount) {
        if (economy == null) {
            ImageMap.plugin.getLogger().warning("Economy instance is null. Cannot reduce player balance.");
            return false;
        }
        if (economy.getBalance((OfflinePlayer)player) < amount) {
            return false;
        }
        economy.withdrawPlayer((OfflinePlayer)player, amount);
        return true;
    }

    public static boolean deductItem(Player player, Material itemType, int quantity) {
        ItemStack itemStack = new ItemStack(itemType, quantity);
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != itemType) continue;
            if (item.getAmount() >= quantity) {
                item.setAmount(item.getAmount() - quantity);
                player.updateInventory();
                return true;
            }
            count += item.getAmount();
        }
        if (count >= quantity) {
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != itemType) continue;
                int currentAmount = item.getAmount();
                if (currentAmount >= quantity) {
                    item.setAmount(currentAmount - quantity);
                    player.updateInventory();
                    return true;
                }
                player.getInventory().remove(item);
                quantity -= currentAmount;
            }
        }
        return false;
    }

    public static boolean hasBlacklistedWords(String[] args2) {
        List blacklistedWords = ImageMap.plugin.getConfig().getStringList("blacklisted-words");
        for (String word : args2) {
            for (String blacklistedWord : blacklistedWords) {
                if (!word.toLowerCase().contains(blacklistedWord.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

