/*
 * Decompiled with CFR 0.152.
 */
package com.spicymike.simplelogin;

import com.spicymike.simplelogin.SimpleLogin;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final SimpleLogin plugin;

    public CommandHandler(SimpleLogin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        switch (command.getName().toLowerCase()) {
            case "register": {
                if (this.plugin.getPasswordConfig().contains(uuid.toString())) {
                    player.sendMessage(this.plugin.getConfig().getString("message.already_registered", "\u00a7cYou are already registered."));
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage("\u00a7cUsage: /register <password> <password>");
                    return true;
                }
                if (!args[0].equals(args[1])) {
                    player.sendMessage(this.plugin.getConfig().getString("message.register_mismatch", "\u00a7cPasswords do not match."));
                    return true;
                }
                this.plugin.getPasswordConfig().set(uuid.toString(), (Object)args[0]);
                this.plugin.savePasswords();
                this.plugin.loggedIn.put(uuid, true);
                player.sendMessage(this.plugin.getConfig().getString("message.register_success", "\u00a7aSuccessfully registered and logged in."));
                return true;
            }
            case "login": {
                if (!this.plugin.getPasswordConfig().contains(uuid.toString())) {
                    player.sendMessage(this.plugin.getConfig().getString("message.not_registered", "\u00a7cYou are not registered."));
                    return true;
                }
                if (this.plugin.loggedIn.getOrDefault(uuid, false).booleanValue()) {
                    player.sendMessage(this.plugin.getConfig().getString("message.already_loggedin", "\u00a7eYou are already logged in."));
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage("\u00a7cUsage: /login <password>");
                    return true;
                }
                String stored = this.plugin.getPasswordConfig().getString(uuid.toString());
                if (stored.equals(args[0])) {
                    this.plugin.loggedIn.put(uuid, true);
                    this.plugin.loginAttempts.put(uuid, 0);
                    player.sendMessage(this.plugin.getConfig().getString("message.login_success", "\u00a7aLogin successful."));
                } else {
                    int attempts = this.plugin.loginAttempts.getOrDefault(uuid, 0) + 1;
                    this.plugin.loginAttempts.put(uuid, attempts);
                    player.sendMessage(this.plugin.getConfig().getString("message.login_fail", "\u00a7cIncorrect password."));
                    if (attempts >= 3) {
                        player.kickPlayer(this.plugin.getConfig().getString("message.too_many_attempts", "\u00a7cToo many incorrect attempts. Kicked."));
                    }
                }
                return true;
            }
            case "delacc": {
                if (!this.plugin.getPasswordConfig().contains(uuid.toString())) {
                    player.sendMessage(this.plugin.getConfig().getString("message.not_registered", "\u00a7cYou are not registered."));
                    return true;
                }
                this.plugin.getPasswordConfig().set(uuid.toString(), null);
                this.plugin.savePasswords();
                this.plugin.loggedIn.put(uuid, false);
                player.sendMessage(this.plugin.getConfig().getString("message.account_deleted", "\u00a7aYour account has been deleted."));
                return true;
            }
            case "changepass": {
                if (!player.isOp() && !sender.hasPermission("simplelogin.changepass")) {
                    player.sendMessage("\u00a7cYou don't have the permissions to use this command.");
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage(this.plugin.getConfig().getString("changepass_usage", "\u00a7cUsage: /changepass <player> <newpass>"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    player.sendMessage(this.plugin.getConfig().getString("player_not_online", "\u00a7cThat player is not online."));
                    return true;
                }
                UUID targetUUID = target.getUniqueId();
                this.plugin.getPasswordConfig().set(targetUUID.toString(), (Object)args[1]);
                this.plugin.savePasswords();
                player.sendMessage(this.plugin.getConfig().getString("changepass_success", "\u00a7aPassword for " + target.getName() + " has been changed."));
                target.sendMessage(this.plugin.getConfig().getString("changepass_notify", "\u00a7eYour password has been changed by an admin. New password: \u00a7f" + args[1]));
                return true;
            }
            case "slreload": {
                if (!player.isOp()) {
                    player.sendMessage("\u00a7cYou don't have permissions to use this command.");
                    return true;
                }
                this.plugin.reloadConfig();
                player.sendMessage("\u00a7aMain config reloaded!");
                return true;
            }
        }
        return false;
    }
}

