/*
 * Decompiled with CFR 0.152.
 */
package com.spicymike.simplelogin;

import com.spicymike.simplelogin.SimpleLogin;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class LoginListener
implements Listener {
    private final SimpleLogin plugin;
    private final Map<String, Boolean> opCache = new HashMap<String, Boolean>();

    public LoginListener(SimpleLogin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        this.plugin.loggedIn.put(player.getUniqueId(), false);
        this.plugin.loginAttempts.put(player.getUniqueId(), 0);
        this.plugin.joinTimestamps.put(player.getUniqueId(), System.currentTimeMillis());
        if (this.plugin.getConfig().getBoolean("enable-blindness-effect", true)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 1, false, false));
        }
        player.setWalkSpeed(0.0f);
        player.setFlySpeed(0.0f);
        long repeatTicks = this.plugin.getConfig().getLong("repeat-message-seconds", 3L) * 20L;
        new BukkitRunnable(){

            public void run() {
                if (!LoginListener.this.plugin.loggedIn.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                    if (!LoginListener.this.plugin.getPasswordConfig().contains(player.getUniqueId().toString())) {
                        player.sendMessage(LoginListener.this.plugin.getConfig().getString("message.register"));
                    } else {
                        player.sendMessage(LoginListener.this.plugin.getConfig().getString("message.login"));
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, repeatTicks);
        int timeout = this.plugin.getConfig().getInt("timeout", 300);
        new BukkitRunnable(){

            public void run() {
                if (!LoginListener.this.plugin.loggedIn.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                    player.kickPlayer(LoginListener.this.plugin.getConfig().getString("message.timeout"));
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)timeout * 20L);
        this.opCache.put(name, player.isOp());
        if (player.isOp()) {
            player.setOp(false);
        }
    }

    public void onSuccessfulLogin(final Player player) {
        String name = player.getName().toLowerCase();
        Boolean wasOp = this.opCache.get(name);
        if (wasOp != null && wasOp.booleanValue()) {
            new BukkitRunnable(){

                public void run() {
                    player.setOp(true);
                }
            }.runTask((Plugin)this.plugin);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        String name = event.getPlayer().getName().toLowerCase();
        this.opCache.remove(name);
        this.plugin.loggedIn.remove(event.getPlayer().getUniqueId());
        this.plugin.loginAttempts.remove(event.getPlayer().getUniqueId());
        this.plugin.joinTimestamps.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && !this.isLogged(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFly(PlayerToggleFlightEvent event) {
        if (!this.isLogged(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.isLogged(player)) {
            if (!event.getFrom().toVector().equals((Object)event.getTo().toVector())) {
                event.setTo(event.getFrom());
            }
        } else {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
            player.setWalkSpeed(0.2f);
            player.setFlySpeed(0.1f);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.isLogged((Player)event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!this.isLogged((Player)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.isLogged(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.isLogged(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (!this.isLogged(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    private boolean isLogged(Player player) {
        return this.plugin.loggedIn.getOrDefault(player.getUniqueId(), false);
    }
}

