/*
 * Decompiled with CFR 0.152.
 */
package com.spicymike.simplelogin;

import com.spicymike.simplelogin.SimpleLogin;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class LoginListener
implements Listener {
    private final SimpleLogin plugin;

    public LoginListener(SimpleLogin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        final UUID uuid = player.getUniqueId();
        this.plugin.loggedIn.put(uuid, false);
        this.plugin.loginAttempts.put(uuid, 0);
        this.plugin.joinTimestamps.put(uuid, System.currentTimeMillis());
        if (this.plugin.getConfig().getBoolean("enable-blindness-effect", true)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 1, false, false));
        }
        player.setWalkSpeed(0.0f);
        player.setFlySpeed(0.0f);
        long repeatTicks = this.plugin.getConfig().getLong("repeat-message-seconds", 3L) * 20L;
        new BukkitRunnable(){

            public void run() {
                if (!LoginListener.this.plugin.loggedIn.getOrDefault(uuid, false).booleanValue()) {
                    if (!LoginListener.this.plugin.getPasswordConfig().contains(uuid.toString())) {
                        player.sendMessage(LoginListener.this.plugin.getConfig().getString("message.register", "\u00a7cPlease register to continue. Use /register <password> <password>"));
                    } else {
                        player.sendMessage(LoginListener.this.plugin.getConfig().getString("message.login", "\u00a7ePlease log in to continue. Use /login <password>"));
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, repeatTicks);
        final int timeout = this.plugin.getConfig().getInt("timeout", 300);
        new BukkitRunnable(){

            public void run() {
                if (!LoginListener.this.plugin.loggedIn.getOrDefault(uuid, false).booleanValue()) {
                    player.kickPlayer(LoginListener.this.plugin.getConfig().getString("message.timeout", "\u00a7cLogin timed out after " + timeout + " seconds."));
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)timeout * 20L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && !this.plugin.loggedIn.getOrDefault((player = (Player)entity).getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerFly(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.loggedIn.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.plugin.loggedIn.remove(uuid);
        this.plugin.loginAttempts.remove(uuid);
        this.plugin.joinTimestamps.remove(uuid);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.loggedIn.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getY() != event.getTo().getY() || event.getFrom().getZ() != event.getTo().getZ()) {
                event.setTo(event.getFrom());
            }
        } else {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
            player.setWalkSpeed(0.2f);
            player.setFlySpeed(0.1f);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player && !this.plugin.loggedIn.getOrDefault((player = (Player)humanEntity).getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player player;
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player && !this.plugin.loggedIn.getOrDefault((player = (Player)humanEntity).getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.loggedIn.getOrDefault(event.getPlayer().getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.loggedIn.getOrDefault(event.getPlayer().getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (!this.plugin.loggedIn.getOrDefault(event.getPlayer().getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }
}

