/*
 * Decompiled with CFR 0.152.
 */
package code.blurone.cowardless.v1_21_4;

import code.blurone.cowardless.Coward;
import code.blurone.cowardless.CowardFactory;
import code.blurone.cowardless.SilentPlayerJoinListener;
import code.blurone.cowardless.SilentPlayerKickListener;
import code.blurone.cowardless.SilentPlayerQuitListener;
import code.blurone.cowardless.shaded.kotlin.Metadata;
import code.blurone.cowardless.shaded.kotlin.collections.ArraysKt;
import code.blurone.cowardless.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import code.blurone.cowardless.shaded.kotlin.jvm.internal.Intrinsics;
import code.blurone.cowardless.shaded.kotlin.jvm.internal.SourceDebugExtension;
import code.blurone.cowardless.v1_21_4.FakeConnection;
import code.blurone.cowardless.v1_21_4.FoliaSGPLI;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcode/blurone/cowardless/v1_21_4/ServerNpc;", "Lnet/minecraft/server/level/ServerPlayer;", "Lcode/blurone/cowardless/Coward;", "plugin", "Lorg/bukkit/plugin/Plugin;", "remainingTicks", "", "server", "Lnet/minecraft/server/MinecraftServer;", "world", "Lnet/minecraft/server/level/ServerLevel;", "profile", "Lcom/mojang/authlib/GameProfile;", "clientOptions", "Lnet/minecraft/server/level/ClientInformation;", "<init>", "(Lorg/bukkit/plugin/Plugin;JLnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerLevel;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/server/level/ClientInformation;)V", "getRemainingTicks", "()J", "setRemainingTicks", "(J)V", "name", "", "getName", "()Ljava/lang/String;", "remove", "", "logMessage", "async", "", "isControlledByClient", "tick", "Companion", "1.21.4"})
public final class ServerNpc
extends ServerPlayer
implements Coward {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    private long remainingTicks;

    public ServerNpc(@NotNull Plugin plugin, long remainingTicks, @NotNull MinecraftServer server, @NotNull ServerLevel world, @NotNull GameProfile profile, @NotNull ClientInformation clientOptions) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(profile, "profile");
        Intrinsics.checkNotNullParameter(clientOptions, "clientOptions");
        super(server, world, profile, clientOptions);
        this.plugin = plugin;
        this.remainingTicks = remainingTicks;
        Coward.Companion.getByName().put(this.getName(), this);
    }

    @Override
    public long getRemainingTicks() {
        return this.remainingTicks;
    }

    @Override
    public void setRemainingTicks(long l) {
        this.remainingTicks = l;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.gameProfile.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    public void remove(@NotNull String logMessage, boolean async) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        Coward.Companion.getByName().remove(this.getName());
        this.plugin.getLogger().info(logMessage);
        HandlerList handlerList = PlayerQuitEvent.getHandlerList();
        Intrinsics.checkNotNullExpressionValue(handlerList, "getHandlerList(...)");
        HandlerList pqeHandlerList = handlerList;
        RegisteredListener[] registeredListenerArray = pqeHandlerList.getRegisteredListeners();
        Intrinsics.checkNotNullExpressionValue(registeredListenerArray, "getRegisteredListeners(...)");
        RegisteredListener[] oldPqeListeners = registeredListenerArray;
        int n = oldPqeListeners.length;
        for (int i = 0; i < n; ++i) {
            RegisteredListener registeredListener = oldPqeListeners[i];
            Intrinsics.checkNotNull(registeredListener);
            RegisteredListener listener = registeredListener;
            pqeHandlerList.unregister(listener);
        }
        HandlerList handlerList2 = PlayerKickEvent.getHandlerList();
        Intrinsics.checkNotNullExpressionValue(handlerList2, "getHandlerList(...)");
        HandlerList pkeHandleList = handlerList2;
        RegisteredListener[] registeredListenerArray2 = pkeHandleList.getRegisteredListeners();
        Intrinsics.checkNotNullExpressionValue(registeredListenerArray2, "getRegisteredListeners(...)");
        RegisteredListener[] oldPkeListeners = registeredListenerArray2;
        int n2 = oldPkeListeners.length;
        for (int listener = 0; listener < n2; ++listener) {
            RegisteredListener registeredListener = oldPkeListeners[listener];
            Intrinsics.checkNotNull(registeredListener);
            RegisteredListener listener2 = registeredListener;
            pkeHandleList.unregister(listener2);
        }
        SilentPlayerQuitListener pqeSilencer = new SilentPlayerQuitListener(oldPqeListeners);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)pqeSilencer, this.plugin);
        SilentPlayerKickListener pkeSilencer = new SilentPlayerKickListener(oldPkeListeners);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)pkeSilencer, this.plugin);
        MutableComponent reason = Component.literal((String)"Cowardless");
        PlayerKickEvent.Cause cause = PlayerKickEvent.Cause.PLUGIN;
        if (async) {
            this.connection.disconnectAsync((Component)reason, cause);
        } else {
            this.connection.disconnect((Component)reason, cause);
        }
    }

    public boolean isControlledByClient() {
        return false;
    }

    public void tick() {
        this.connection.handleMovePlayer((ServerboundMovePlayerPacket)new ServerboundMovePlayerPacket.StatusOnly(this.onGround(), true));
        super.tick();
        this.doTick();
        long l = this.getRemainingTicks();
        this.setRemainingTicks(l + -1L);
        if (l == 0L) {
            this.remove(this.getName() + "'s NPCoward has expired.", false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcode/blurone/cowardless/v1_21_4/ServerNpc$Companion;", "Lcode/blurone/cowardless/CowardFactory;", "<init>", "()V", "createNpc", "Lcode/blurone/cowardless/Coward;", "plugin", "Lorg/bukkit/plugin/Plugin;", "player", "Lorg/bukkit/entity/Player;", "despawnTicksThreshold", "", "isFolia", "", "1.21.4"})
    @SourceDebugExtension(value={"SMAP\nServerNpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerNpc.kt\ncode/blurone/cowardless/v1_21_4/ServerNpc$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
    public static final class Companion
    implements CowardFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public Coward createNpc(@NotNull Plugin plugin, @NotNull Player player, long despawnTicksThreshold, boolean isFolia) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(player, "player");
            ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            ServerLevel level = serverPlayer.serverLevel();
            MinecraftServer minecraftServer = level.getServer();
            Intrinsics.checkNotNullExpressionValue(minecraftServer, "getServer(...)");
            MinecraftServer server = minecraftServer;
            GameProfile profile = ((CraftPlayer)player).getProfile();
            CommonListenerCookie commonListenerCookie = CommonListenerCookie.createInitial((GameProfile)profile, (boolean)true);
            Intrinsics.checkNotNullExpressionValue(commonListenerCookie, "createInitial(...)");
            CommonListenerCookie cookie = commonListenerCookie;
            Intrinsics.checkNotNull(level);
            Intrinsics.checkNotNull(profile);
            ClientInformation clientInformation = cookie.clientInformation();
            Intrinsics.checkNotNullExpressionValue(clientInformation, "clientInformation(...)");
            ServerNpc serverNPC = new ServerNpc(plugin, despawnTicksThreshold, server, level, profile, clientInformation);
            HandlerList handlerList = PlayerSpawnLocationEvent.getHandlerList();
            Intrinsics.checkNotNullExpressionValue(handlerList, "getHandlerList(...)");
            HandlerList psleHandlerList = handlerList;
            RegisteredListener[] registeredListenerArray = psleHandlerList.getRegisteredListeners();
            Intrinsics.checkNotNullExpressionValue(registeredListenerArray, "getRegisteredListeners(...)");
            RegisteredListener[] oldPsleListeners = registeredListenerArray;
            int n = oldPsleListeners.length;
            for (int i = 0; i < n; ++i) {
                RegisteredListener registeredListener = oldPsleListeners[i];
                Intrinsics.checkNotNull(registeredListener);
                RegisteredListener listener = registeredListener;
                psleHandlerList.unregister(listener);
            }
            HandlerList handlerList2 = PlayerJoinEvent.getHandlerList();
            Intrinsics.checkNotNullExpressionValue(handlerList2, "getHandlerList(...)");
            HandlerList pjeHandlerList = handlerList2;
            RegisteredListener[] registeredListenerArray2 = pjeHandlerList.getRegisteredListeners();
            Intrinsics.checkNotNullExpressionValue(registeredListenerArray2, "getRegisteredListeners(...)");
            RegisteredListener[] oldPjeListeners = registeredListenerArray2;
            int n2 = oldPjeListeners.length;
            for (int listener = 0; listener < n2; ++listener) {
                RegisteredListener registeredListener = oldPjeListeners[listener];
                Intrinsics.checkNotNull(registeredListener);
                RegisteredListener listener2 = registeredListener;
                pjeHandlerList.unregister(listener2);
            }
            SilentPlayerJoinListener pjeSilencer = new SilentPlayerJoinListener(oldPjeListeners, plugin.getConfig().getBoolean("chat_message", true));
            plugin.getServer().getPluginManager().registerEvents((Listener)pjeSilencer, plugin);
            FakeConnection connection = new FakeConnection();
            ServerConfigurationPacketListenerImpl scpli = new ServerConfigurationPacketListenerImpl(server, (Connection)connection, cookie, (ServerPlayer)serverNPC);
            scpli.returnToWorld();
            ServerboundFinishConfigurationPacket.INSTANCE.handle((ServerConfigurationPacketListener)scpli);
            psleHandlerList.registerAll((Collection)ArraysKt.toList(oldPsleListeners));
            if (isFolia) {
                serverNPC.getBukkitEntity().getScheduler().run(plugin, arg_0 -> Companion.createNpc$lambda$0(server, connection, serverNPC, cookie, arg_0), null);
            }
            List list = serverPlayer.getEntityData().getNonDefaultValues();
            if (list != null) {
                List list2 = list;
                SynchedEntityData synchedEntityData = serverNPC.entityData;
                Intrinsics.checkNotNullExpressionValue(synchedEntityData, "access$getEntityData$p$s1806514302(...)");
                SynchedEntityData synchedEntityData2 = synchedEntityData;
                List p0 = list2;
                boolean bl = false;
                synchedEntityData2.assignValues(p0);
            }
            serverNPC.invulnerableTime = 0;
            serverNPC.setInvulnerable(false);
            serverNPC.setClientLoaded(true);
            serverNPC.uuid = ((CraftPlayer)player).getUniqueId();
            serverNPC.bukkitPickUpLoot = false;
            return serverNPC;
        }

        private static final void createNpc$lambda$0(MinecraftServer $server, FakeConnection $connection, ServerNpc $serverNPC, CommonListenerCookie $cookie, ScheduledTask it) {
            FoliaSGPLI foliaSGPLI = new FoliaSGPLI($server, $connection, $serverNPC, $cookie);
            $connection.setupInboundProtocol(GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator((RegistryAccess)((RegistryAccess)$server.registryAccess()))), (PacketListener)foliaSGPLI);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

