/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.mixin;

import com.frikinjay.almanac.util.ItemNBTUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slot.class})
public abstract class SlotMixin {
    @Shadow
    @Final
    public Container container;
    @Shadow
    @Final
    private int slot;

    @Inject(method={"getItem()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getItemInject(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack stack;
        if (this.container != null && ItemNBTUtil.isSplitItemStack(stack = this.container.getItem(this.slot))) {
            stack.remove(DataComponents.CUSTOM_DATA);
            cir.setReturnValue((Object)stack);
        }
    }

    @Inject(method={"set(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setInject(ItemStack stack, CallbackInfo ci) {
        ItemNBTUtil.fixBug(stack);
    }

    @Inject(method={"onQuickCraft(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onQuickCraftInject(ItemStack stack1, ItemStack stack2, CallbackInfo ci) {
        ItemNBTUtil.fixBug(stack1);
        ItemNBTUtil.fixBug(stack2);
    }

    @Inject(method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTakeInject(Player player, ItemStack stack, CallbackInfo ci) {
        ItemNBTUtil.fixBug(stack);
    }

    @Inject(method={"mayPlace(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mayPlaceInject(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        ItemNBTUtil.fixBug(stack);
    }

    @Inject(method={"setByPlayer(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setByPlayerInject(ItemStack stack, CallbackInfo ci) {
        ItemNBTUtil.fixBug(stack);
    }
}

