package com.frikinjay.almanac.config.fabric;

import com.frikinjay.almanac.Almanac;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

import java.util.Arrays;
import java.util.List;

@Config(name = Almanac.MOD_ID+"-nbtFix")
public class AlmanacConfigFabric implements ConfigData {
    // Settings
    @ConfigEntry.Gui.CollapsibleObject
    public Blacklist items = new Blacklist();

    public static class Blacklist {
        @Comment(value = "Items in this list will not be modified by ItemSplitBugFix.\n" +
                "Supports wildcard '*'. For example:\n" +
                "- 'minecraft:diamond' matches exactly 'minecraft:diamond'\n" +
                "- '*:diamond*' matches any item from any mod that contains 'diamond'\n" +
                "- 'minecraft:*' matches all items from minecraft namespace\n" +
                "- '*nec*' matches any item that contains 'nec', eg. 'necromancy:abc', 'my_mod:necklace'")
        public List<String> blacklistItems = Arrays.asList(
                "alexscaves:sack_of_sating",
                "hexerei:*",
                "spelunkery:*",
                "minecraft:spyglass",
                "technicalcores:*"
        );
    }

}
