/*
 * Decompiled with CFR 0.152.
 */
package me.lucievol.forbiddenblocks;

import com.google.gson.JsonNull;
import java.util.Optional;
import java.util.TreeMap;
import me.lucievol.forbiddenblocks.config.ForbiddenBlocksConfig;
import me.lucievol.forbiddenblocks.config.WorldConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2304;
import net.minecraft.class_2323;
import net.minecraft.class_2343;
import net.minecraft.class_2349;
import net.minecraft.class_2387;
import net.minecraft.class_2401;
import net.minecraft.class_2428;
import net.minecraft.class_2484;
import net.minecraft.class_2533;
import net.minecraft.class_2549;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3711;
import net.minecraft.class_3712;
import net.minecraft.class_3713;
import net.minecraft.class_3718;
import net.minecraft.class_3830;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5803;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForbiddenBlocksClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"forbiddenblocks");
    private static final Object KEY_LOCK = new Object();
    private volatile boolean isHandlingKeyPress = false;
    private static boolean isConnected = false;
    private static String lastConnectedServer = "";
    private static final class_304 FORBID_KEY = new class_304("key.forbiddenblocks.forbid", class_3675.class_307.field_1668, 79, "category.forbiddenblocks.keys");
    private static final class_304 TOGGLE_MESSAGES_KEY = new class_304("key.forbiddenblocks.toggle_messages", class_3675.class_307.field_1668, 77, "category.forbiddenblocks.keys");

    public static void updateConnectionState(boolean connected, String serverAddress) {
        LOGGER.info("CONNECTION UPDATE - Previous state: Connected={}, Server={}", (Object)isConnected, (Object)lastConnectedServer);
        isConnected = connected;
        lastConnectedServer = serverAddress;
        LOGGER.info("CONNECTION UPDATE - New state: Connected={}, Server={}", (Object)connected, (Object)serverAddress);
        LOGGER.info("CONNECTION UPDATE - Requesting WorldConfig update");
        WorldConfig.updateForCurrentWorld();
    }

    public static boolean isConnected() {
        return isConnected;
    }

    public static String getLastConnectedServer() {
        return lastConnectedServer;
    }

    public void onInitializeClient() {
        ForbiddenBlocksConfig.init();
        KeyBindingHelper.registerKeyBinding((class_304)FORBID_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)TOGGLE_MESSAGES_KEY);
        UseBlockCallback.EVENT.register(this::onBlockUse);
        UseEntityCallback.EVENT.register(this::onEntityUse);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.info("Client shutting down, saving configurations");
            WorldConfig.saveAll();
        }));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_642 serverInfo = client.method_1558();
            String serverAddress = "unknown";
            if (serverInfo != null) {
                serverAddress = serverInfo.field_3761;
                LOGGER.info("MULTIPLAYER JOIN EVENT: Connected to server: {}. Server info: {}", (Object)serverAddress, (Object)serverInfo.field_3752);
            } else {
                try {
                    serverAddress = handler.method_48296().method_10755().toString();
                    LOGGER.info("MULTIPLAYER JOIN EVENT: Connected to server via address: {}", (Object)serverAddress);
                }
                catch (Exception e) {
                    LOGGER.error("MULTIPLAYER JOIN EVENT: Failed to get server address from handler", (Throwable)e);
                }
            }
            ForbiddenBlocksClient.updateConnectionState(true, serverAddress);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("MULTIPLAYER DISCONNECT EVENT: Disconnected from server: {}", (Object)lastConnectedServer);
            ForbiddenBlocksClient.updateConnectionState(false, "");
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!this.isValidGameState(client)) {
                return;
            }
            if (!this.isHandlingKeyPress) {
                Object object = KEY_LOCK;
                synchronized (object) {
                    try {
                        this.isHandlingKeyPress = true;
                        this.handleKeyPresses(client);
                    }
                    finally {
                        this.isHandlingKeyPress = false;
                    }
                }
            }
        });
        LOGGER.info("ForbiddenBlocks client initialized");
    }

    private boolean isValidGameState(class_310 client) {
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        return client.method_22108() && client.field_1755 == null;
    }

    private void handleKeyPresses(class_310 client) {
        try {
            if (FORBID_KEY.method_1436()) {
                LOGGER.info("Forbid key pressed - starting forbid item process");
                client.execute(() -> this.forbidItem(client.field_1724));
            }
            if (TOGGLE_MESSAGES_KEY.method_1436()) {
                LOGGER.info("Toggle messages key pressed");
                client.execute(() -> ForbiddenBlocksClient.toggleMessages(client.field_1724));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error handling key press", (Throwable)e);
        }
    }

    private static WorldConfig.ItemIdentifier getItemIdentifier(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            LOGGER.warn("Attempted to get identifier for null/empty stack");
            return null;
        }
        try {
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (id == null) {
                LOGGER.warn("Item has no registry ID: {}", (Object)stack);
                return null;
            }
            String registryId = id.toString();
            String displayName = stack.method_7964().getString();
            LOGGER.debug("getItemIdentifier: Processing item - Registry ID: {}, Display Name: {}", (Object)registryId, (Object)displayName);
            class_9323 currentComponents = stack.method_57353();
            TreeMap<String, Object> componentJsonMap = new TreeMap<String, Object>();
            for (class_9331 componentType : class_7923.field_49658) {
                if (!stack.method_57826(componentType)) continue;
                Object actualValue = stack.method_58694(componentType);
                class_2960 componentTypeId = class_7923.field_49658.method_10221((Object)componentType);
                if (actualValue instanceof Optional) {
                    actualValue = ((Optional)actualValue).orElse(null);
                }
                Object valueForRegistryEntryToString = actualValue;
                if (actualValue instanceof class_6880) {
                    class_2960 currentComponentIdForLog = componentTypeId;
                    actualValue = ((class_6880)actualValue).method_40230().map(key -> key.method_29177().toString()).orElseGet(() -> {
                        String idForLog = currentComponentIdForLog != null ? currentComponentIdForLog.toString() : componentType.toString();
                        LOGGER.warn("getItemIdentifier: Component {} for item {} is a RegistryEntry without a key. Using its toString() as fallback.", (Object)idForLog, (Object)registryId);
                        return valueForRegistryEntryToString.toString();
                    });
                }
                if (componentTypeId != null) {
                    String componentIdStr = componentTypeId.toString();
                    if (componentIdStr.equals("minecraft:item_name") || componentIdStr.equals("minecraft:item_model") || componentIdStr.equals("minecraft:attribute_modifiers") || componentIdStr.equals("minecraft:break_sound")) continue;
                    if (actualValue != null) {
                        LOGGER.debug("getItemIdentifier: Found component - ID: {}, Value Class: {}", (Object)componentIdStr, (Object)actualValue.getClass().getName());
                        try {
                            componentJsonMap.put(componentIdStr, WorldConfig.GSON.toJsonTree(actualValue));
                        }
                        catch (Exception e_comp) {
                            LOGGER.error("getItemIdentifier: Failed to serialize component {} for item {}. Value Class: {}. Error: {}", new Object[]{componentIdStr, registryId, actualValue.getClass().getName(), e_comp.getMessage(), e_comp});
                        }
                        continue;
                    }
                    LOGGER.debug("getItemIdentifier: Component {} is present but its value is null for item {}.", (Object)componentIdStr, (Object)registryId);
                    componentJsonMap.put(componentIdStr, JsonNull.INSTANCE);
                    continue;
                }
                LOGGER.warn("getItemIdentifier: ComponentType {} has null ID in registry for item {}. Skipping.", (Object)componentType, (Object)registryId);
            }
            String componentsJson = WorldConfig.GSON.toJson(componentJsonMap);
            LOGGER.debug("getItemIdentifier: Final components JSON for {}: {}", (Object)registryId, (Object)componentsJson);
            WorldConfig.ItemIdentifier resultIdentifier = new WorldConfig.ItemIdentifier(registryId, displayName, componentsJson);
            LOGGER.debug("getItemIdentifier: Created ItemIdentifier: {}", (Object)resultIdentifier.toString());
            return resultIdentifier;
        }
        catch (Exception e) {
            LOGGER.error("Error getting item identifier for stack " + stack.toString(), (Throwable)e);
            return null;
        }
    }

    private class_1269 onBlockUse(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_2680 targetBlockStateInitial = world.method_8320(hitResult.method_17777());
        class_2248 targetBlockInitial = targetBlockStateInitial.method_26204();
        LOGGER.debug("[DEBUG_INTERACTION] onBlockUse - Target Block Class: {}, Target Block State: {}", (Object)targetBlockInitial.getClass().getName(), (Object)targetBlockStateInitial.toString());
        if (!(player instanceof class_746)) {
            return class_1269.field_5811;
        }
        class_746 clientPlayer = (class_746)player;
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7960()) {
            return class_1269.field_5811;
        }
        WorldConfig.ItemIdentifier itemIdentifier = ForbiddenBlocksClient.getItemIdentifier(stackInHand);
        if (itemIdentifier == null) {
            LOGGER.warn("onBlockUse: Could not get ItemIdentifier for stack: {}", (Object)stackInHand);
            return class_1269.field_5811;
        }
        String itemName = stackInHand.method_7964().getString();
        WorldConfig worldConfig = WorldConfig.getCurrentWorld();
        boolean isForbidden = worldConfig.isItemForbidden(itemIdentifier);
        LOGGER.debug("onBlockUse: Item: {}, Hand: {}, Forbidden: {}, Target: {}", new Object[]{itemName, hand, isForbidden, hitResult.method_17777()});
        if ((targetBlockInitial instanceof class_2484 || targetBlockInitial instanceof class_2549) && isForbidden && hand == class_1268.field_5808) {
            if (ForbiddenBlocksConfig.get().shouldShowMessages()) {
                clientPlayer.method_7353(class_2561.method_30163((String)("\u00a7cYou cannot place " + itemName + " on a skull block! (Client-Side)")), false);
            }
            LOGGER.info("Blocked placement of forbidden item: {} (Registry: {}) on SkullBlock/WallSkullBlock", (Object)itemName, (Object)itemIdentifier.getRegistryId());
            return class_1269.field_5814;
        }
        if (isForbidden) {
            class_2680 targetBlockState = targetBlockStateInitial;
            class_2248 targetBlock = targetBlockInitial;
            if (hand == class_1268.field_5808) {
                if (!(targetBlock instanceof class_2387) && (targetBlock instanceof class_2343 || targetBlock instanceof class_2323 || targetBlock instanceof class_2533 || targetBlock instanceof class_2349 || targetBlock instanceof class_2304 || targetBlock instanceof class_2199 || targetBlock instanceof class_3713 || targetBlock instanceof class_3718 || targetBlock instanceof class_3711 || targetBlock instanceof class_3712 || targetBlock instanceof class_2269 || targetBlock instanceof class_2401 || targetBlock instanceof class_2428)) {
                    LOGGER.info("Allowing interaction with utility/job block '{}' (excluding Jukebox) with forbidden item '{}' in main hand.", (Object)targetBlock.method_9518().getString(), (Object)itemName);
                    return class_1269.field_5811;
                }
                if (!(targetBlock instanceof class_2387)) {
                    if (targetBlock instanceof class_3830) {
                        if ((Integer)targetBlockState.method_11654((class_2769)class_2741.field_12497) == 3) {
                            LOGGER.info("Allowing sweet berry harvest from '{}' with forbidden item '{}' in main hand.", (Object)targetBlock.method_9518().getString(), (Object)itemName);
                            return class_1269.field_5811;
                        }
                    } else if (targetBlock instanceof class_5803 && targetBlockState.method_28498((class_2769)class_2741.field_28716) && ((Boolean)targetBlockState.method_11654((class_2769)class_2741.field_28716)).booleanValue()) {
                        LOGGER.info("Allowing glow berry harvest from CaveVines block '{}' with forbidden item '{}' in main hand.", (Object)targetBlock.method_9518().getString(), (Object)itemName);
                        return class_1269.field_5811;
                    }
                }
                if (ForbiddenBlocksConfig.get().shouldShowMessages()) {
                    clientPlayer.method_7353(class_2561.method_30163((String)("\u00a7cYou cannot place " + itemName + "! (Client-Side)")), false);
                }
                LOGGER.info("Blocked placement of forbidden item: {} (Registry: {}) with {} hand on block {}", new Object[]{itemName, itemIdentifier.getRegistryId(), hand, targetBlock.method_9518().getString()});
                return class_1269.field_5814;
            }
            if (ForbiddenBlocksConfig.get().shouldShowMessages()) {
                clientPlayer.method_7353(class_2561.method_30163((String)("\u00a7cYou cannot place " + itemName + "! (Client-Side)")), false);
            }
            LOGGER.info("Blocked placement/interaction with forbidden item: {} (Registry: {}) with {} hand on block {}", new Object[]{itemName, itemIdentifier.getRegistryId(), hand, targetBlock.method_9518().getString()});
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private class_1269 onEntityUse(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (!(player instanceof class_746)) {
            return class_1269.field_5811;
        }
        class_746 clientPlayer = (class_746)player;
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7960()) {
            return class_1269.field_5811;
        }
        WorldConfig.ItemIdentifier itemIdentifier = ForbiddenBlocksClient.getItemIdentifier(stackInHand);
        if (itemIdentifier == null) {
            LOGGER.warn("onEntityUse: Could not get ItemIdentifier for stack: {}", (Object)stackInHand);
            return class_1269.field_5811;
        }
        String itemName = stackInHand.method_7964().getString();
        WorldConfig worldConfig = WorldConfig.getCurrentWorld();
        boolean isForbidden = worldConfig.isItemForbidden(itemIdentifier);
        LOGGER.debug("onEntityUse: Item: {}, Hand: {}, Forbidden: {}, TargetEntity: {}", new Object[]{itemName, hand, isForbidden, entity.method_5477().getString()});
        if (isForbidden) {
            if (hand == class_1268.field_5808 && (entity instanceof class_1533 || entity instanceof class_1309)) {
                LOGGER.info("Allowing interaction with entity '{}' with forbidden item '{}' in main hand.", (Object)entity.method_5477().getString(), (Object)itemName);
                return class_1269.field_5811;
            }
            if (ForbiddenBlocksConfig.get().shouldShowMessages()) {
                clientPlayer.method_7353(class_2561.method_30163((String)("\u00a7cAction with " + itemName + " on " + entity.method_5477().getString() + " is blocked! (Client-Side)")), false);
            }
            LOGGER.info("Blocked entity interaction with forbidden item: {} (Registry: {}) with {} hand on entity {}", new Object[]{itemName, itemIdentifier.getRegistryId(), hand, entity.method_5477().getString()});
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private void forbidItem(class_746 player) {
        if (player == null) {
            LOGGER.warn("Attempted to forbid item for null player");
            return;
        }
        class_1799 stack = player.method_6047();
        if (stack == null || stack.method_7960()) {
            player.method_7353(class_2561.method_30163((String)"\u00a7cYou must hold an item to forbid/allow it."), false);
            return;
        }
        String itemName = stack.method_7964().getString();
        WorldConfig.ItemIdentifier itemIdentifier = ForbiddenBlocksClient.getItemIdentifier(stack);
        if (itemIdentifier == null) {
            player.method_7353(class_2561.method_30163((String)("\u00a7cCould not identify the item: " + itemName)), false);
            LOGGER.warn("Could not get ItemIdentifier for stack in forbidItem: {}", (Object)stack);
            return;
        }
        WorldConfig config = WorldConfig.getCurrentWorld();
        config.toggleItem(itemIdentifier);
        if (ForbiddenBlocksConfig.get().shouldShowMessages()) {
            boolean isForbidden = config.isItemForbidden(itemIdentifier);
            if (isForbidden) {
                player.method_7353(class_2561.method_30163((String)("\u00a7e" + itemName + " is now forbidden to place. (Client-Side)")), false);
            } else {
                player.method_7353(class_2561.method_30163((String)("\u00a7a" + itemName + " is now allowed again. (Client-Side)")), false);
            }
        }
    }

    private static void toggleMessages(class_746 player) {
        try {
            if (player == null) {
                LOGGER.warn("Cannot toggle messages - player is null");
                return;
            }
            ForbiddenBlocksConfig config = ForbiddenBlocksConfig.get();
            config.toggleMessages();
            boolean showMessages = config.shouldShowMessages();
            LOGGER.info("Messages are now {}", (Object)(showMessages ? "enabled" : "disabled"));
            player.method_7353(class_2561.method_30163((String)(showMessages ? "\u00a7aForbiddenBlocks messages enabled" : "\u00a7eForbiddenBlocks messages disabled")), false);
        }
        catch (Exception e) {
            LOGGER.error("Error toggling message visibility", (Throwable)e);
        }
    }
}

