/*
 * Decompiled with CFR 0.152.
 */
package me.lucievol.forbiddenblocks.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(name="forbiddenblocks")
public class ForbiddenBlocksConfig
implements ConfigData {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"forbiddenblocks");
    private boolean showMessages = true;

    public static void init() {
        try {
            AutoConfig.register(ForbiddenBlocksConfig.class, Toml4jConfigSerializer::new);
            LOGGER.info("ForbiddenBlocks config system initialized");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize config system", (Throwable)e);
        }
    }

    public static ForbiddenBlocksConfig get() {
        try {
            return (ForbiddenBlocksConfig)AutoConfig.getConfigHolder(ForbiddenBlocksConfig.class).getConfig();
        }
        catch (Exception e) {
            LOGGER.error("Error accessing config", (Throwable)e);
            return new ForbiddenBlocksConfig();
        }
    }

    public boolean shouldShowMessages() {
        return this.showMessages;
    }

    public void toggleMessages() {
        try {
            this.showMessages = !this.showMessages;
            LOGGER.info("Message visibility toggled to: {}", (Object)this.showMessages);
            ForbiddenBlocksConfig.saveConfig();
        }
        catch (Exception e) {
            LOGGER.error("Error toggling messages", (Throwable)e);
        }
    }

    private static void saveConfig() {
        try {
            AutoConfig.getConfigHolder(ForbiddenBlocksConfig.class).save();
            LOGGER.debug("Configuration saved successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to save configuration", (Throwable)e);
        }
    }

    public static class_437 createConfigScreen(class_437 parent) {
        try {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(class_2561.method_30163((String)"Forbidden Blocks Settings"));
            ConfigCategory general = builder.getOrCreateCategory(class_2561.method_30163((String)"General"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(class_2561.method_30163((String)"Show Messages"), ForbiddenBlocksConfig.get().showMessages).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_30163((String)"Show feedback messages when toggling blocks or changing settings")}).setSaveConsumer(value -> {
                ForbiddenBlocksConfig.get().showMessages = value;
                ForbiddenBlocksConfig.saveConfig();
            }).build());
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.error("Error creating config screen", (Throwable)e);
            return parent;
        }
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        super.validatePostLoad();
    }
}

