/*
 * Decompiled with CFR 0.152.
 */
package me.lucievol.forbiddenblocks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"forbiddenblocks");
    private static final String CONFIG_DIR = "config/forbiddenblocks/worlds";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ConcurrentHashMap<String, WorldConfig> WORLD_CONFIGS = new ConcurrentHashMap();
    private static final Object CONFIG_LOCK = new Object();
    private static final TypeToken<HashSet<ItemIdentifier>> ITEM_IDENTIFIER_SET_TYPE = new TypeToken<HashSet<ItemIdentifier>>(){};
    private static String currentConnectionId = null;
    private static final Object CONNECTION_LOCK = new Object();
    private final String worldId;
    private final Set<ItemIdentifier> forbiddenItems;
    private final File configFile;
    private volatile boolean isDirty;

    private WorldConfig(String worldId) {
        this.worldId = worldId;
        this.forbiddenItems = ConcurrentHashMap.newKeySet();
        this.configFile = WorldConfig.getConfigFile(worldId);
        this.isDirty = false;
        this.load();
    }

    public static void saveAll() {
        LOGGER.info("Saving all world configurations");
        for (WorldConfig config : WORLD_CONFIGS.values()) {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConnection(class_634 networkHandler) {
        Object object = CONNECTION_LOCK;
        synchronized (object) {
            if (networkHandler == null) {
                LOGGER.info("Network connection closed, clearing connection ID");
                currentConnectionId = null;
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.method_1542()) {
                String worldName = client.method_1576() != null ? client.method_1576().method_27728().method_150() : "unknown";
                currentConnectionId = "singleplayer_" + worldName;
                LOGGER.info("Updated connection: Singleplayer world '{}'", (Object)worldName);
            } else {
                class_642 serverInfo = client.method_1558();
                String serverAddress = "unknown";
                if (serverInfo != null) {
                    serverAddress = serverInfo.field_3761;
                    LOGGER.info("Server info available: {}", (Object)serverInfo.field_3761);
                } else {
                    try {
                        serverAddress = networkHandler.method_48296().method_10755().toString();
                        if (serverAddress.startsWith("/")) {
                            serverAddress = serverAddress.substring(1);
                        }
                        LOGGER.info("Using network handler address: {}", (Object)serverAddress);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not get server address from network handler", (Throwable)e);
                    }
                }
                serverAddress = serverAddress.replace(':', '_');
                currentConnectionId = "multiplayer_" + serverAddress;
                LOGGER.info("Updated connection: Multiplayer server '{}' -> config ID '{}'", (Object)serverAddress, (Object)currentConnectionId);
            }
            WorldConfig config = WorldConfig.getCurrentWorld();
            config.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorldConfig getCurrentWorld() {
        Object worldId;
        Object object = CONNECTION_LOCK;
        synchronized (object) {
            if (currentConnectionId != null) {
                worldId = currentConnectionId;
            } else {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    LOGGER.warn("No client instance available");
                    worldId = "unknown";
                } else if (client.method_1542()) {
                    String worldName = client.method_1576() != null ? client.method_1576().method_27728().method_150() : "unknown";
                    worldId = "singleplayer_" + worldName;
                } else {
                    class_642 serverInfo = client.method_1558();
                    worldId = serverInfo != null ? "multiplayer_" + serverInfo.field_3761 : "unknown";
                }
            }
        }
        LOGGER.debug("Getting config for world: {}", worldId);
        return WORLD_CONFIGS.computeIfAbsent((String)worldId, WorldConfig::new);
    }

    public static void updateForCurrentWorld() {
        String previousId = currentConnectionId;
        WorldConfig config = WorldConfig.getCurrentWorld();
        LOGGER.info("WORLDCONFIG: Updated config - Previous ID: {}, Current ID: {}", (Object)previousId, (Object)config.worldId);
        LOGGER.info("WORLDCONFIG: Loading configuration for world: {}", (Object)config.worldId);
        config.load();
    }

    private static String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[\\\\/:*?\"<>|]", "_");
    }

    private static File getConfigFile(String worldId) {
        try {
            File minecraftDir = class_310.method_1551().field_1697;
            File configDir = new File(minecraftDir, CONFIG_DIR);
            if (!configDir.exists() && !configDir.mkdirs()) {
                LOGGER.error("Failed to create config directory: {}", (Object)configDir.getAbsolutePath());
                throw new IOException("Could not create config directory");
            }
            String safeWorldId = WorldConfig.sanitizeFileName(worldId);
            LOGGER.debug("WORLDCONFIG: Sanitized world ID '{}' to '{}'", (Object)worldId, (Object)safeWorldId);
            File configFile = new File(configDir, safeWorldId + ".json");
            LOGGER.info("Config file path: {}", (Object)configFile.getAbsolutePath());
            return configFile;
        }
        catch (Exception e) {
            LOGGER.error("Error creating config file for world: " + worldId, (Throwable)e);
            return new File("fallback.json");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            LOGGER.info("WORLDCONFIG: Attempting to load config from: {}", (Object)this.configFile.getAbsolutePath());
            if (!this.configFile.exists()) {
                LOGGER.info("WORLDCONFIG: No existing config for world {}, creating new file at {}", (Object)this.worldId, (Object)this.configFile.getAbsolutePath());
                this.save();
                return;
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile, StandardCharsets.UTF_8));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
                Set items = (Set)GSON.fromJson(content.toString(), ITEM_IDENTIFIER_SET_TYPE.getType());
                if (items != null) {
                    this.forbiddenItems.clear();
                    this.forbiddenItems.addAll(items);
                    LOGGER.info("WORLDCONFIG: Loaded {} forbidden items for world {}", (Object)items.size(), (Object)this.worldId);
                    if (!items.isEmpty()) {
                        LOGGER.info("WORLDCONFIG: Sample of forbidden items: {}", (Object)items.stream().limit(3L).map(Object::toString).collect(Collectors.joining(", ")));
                    }
                } else {
                    LOGGER.warn("WORLDCONFIG: Loaded null items set from file: {}", (Object)this.configFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                LOGGER.error("WORLDCONFIG: Error loading config for world: " + this.worldId, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            try {
                if (!this.configFile.getParentFile().exists()) {
                    LOGGER.info("Creating parent directories for config file: {}", (Object)this.configFile.getAbsolutePath());
                    this.configFile.getParentFile().mkdirs();
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile, StandardCharsets.UTF_8));){
                    String json = GSON.toJson(this.forbiddenItems);
                    writer.write(json);
                    this.isDirty = false;
                    LOGGER.info("Saved config for world {} with {} items to {}", new Object[]{this.worldId, this.forbiddenItems.size(), this.configFile.getAbsolutePath()});
                }
            }
            catch (Exception e) {
                LOGGER.error("Error saving config for world: " + this.worldId, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleItem(ItemIdentifier itemIdentifier) {
        if (itemIdentifier == null) {
            LOGGER.warn("WORLDCONFIG: Attempted to toggle null item identifier");
            return;
        }
        try {
            Object object = CONFIG_LOCK;
            synchronized (object) {
                LOGGER.info("WORLDCONFIG: Toggling item {} in world {} (config file: {})", new Object[]{itemIdentifier, this.worldId, this.configFile.getAbsolutePath()});
                if (this.forbiddenItems.contains(itemIdentifier)) {
                    this.forbiddenItems.remove(itemIdentifier);
                    LOGGER.info("WORLDCONFIG: Removed {} from forbidden items", (Object)itemIdentifier);
                } else {
                    this.forbiddenItems.add(itemIdentifier);
                    LOGGER.info("WORLDCONFIG: Added {} to forbidden items", (Object)itemIdentifier);
                }
                this.isDirty = true;
                LOGGER.info("WORLDCONFIG: Triggering immediate save after toggle");
                this.save();
                if (this.configFile.exists()) {
                    LOGGER.info("WORLDCONFIG: Config file exists after save: {}, size: {} bytes", (Object)this.configFile.getAbsolutePath(), (Object)this.configFile.length());
                } else {
                    LOGGER.error("WORLDCONFIG: Config file does not exist after save attempt: {}", (Object)this.configFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("WORLDCONFIG: Error toggling item: " + String.valueOf(itemIdentifier), (Throwable)e);
        }
    }

    public boolean isItemForbidden(ItemIdentifier itemIdentifier) {
        if (itemIdentifier == null) {
            return false;
        }
        boolean forbidden = this.forbiddenItems.contains(itemIdentifier);
        LOGGER.debug("Checking if item {} is forbidden: {}", (Object)itemIdentifier, (Object)forbidden);
        return forbidden;
    }

    public static class ItemIdentifier {
        private final String registryId;
        private final String name;
        private final String componentsJson;

        public ItemIdentifier(String registryId, String name, String componentsJson) {
            this.registryId = registryId;
            this.name = name;
            if (componentsJson != null && !componentsJson.isEmpty()) {
                JsonElement element = JsonParser.parseString((String)componentsJson);
                this.componentsJson = GSON.toJson(ItemIdentifier.sortJsonElement(element));
            } else {
                this.componentsJson = componentsJson;
            }
        }

        private static JsonElement sortJsonElement(JsonElement element) {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                JsonObject sortedObj = new JsonObject();
                ArrayList entries = new ArrayList(obj.entrySet());
                entries.sort(Map.Entry.comparingByKey());
                for (Map.Entry entry : entries) {
                    sortedObj.add((String)entry.getKey(), ItemIdentifier.sortJsonElement((JsonElement)entry.getValue()));
                }
                return sortedObj;
            }
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                JsonArray sortedArray = new JsonArray();
                ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
                for (JsonElement jsonElement : array) {
                    elements.add(ItemIdentifier.sortJsonElement(jsonElement));
                }
                for (JsonElement jsonElement : elements) {
                    sortedArray.add(jsonElement);
                }
                return sortedArray;
            }
            return element;
        }

        public String getRegistryId() {
            return this.registryId;
        }

        public String getName() {
            return this.name;
        }

        public String getComponentsJson() {
            return this.componentsJson;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemIdentifier that = (ItemIdentifier)o;
            return Objects.equals(this.registryId, that.registryId) && Objects.equals(this.name, that.name) && Objects.equals(this.componentsJson, that.componentsJson);
        }

        public int hashCode() {
            return Objects.hash(this.registryId, this.name, this.componentsJson);
        }

        public String toString() {
            return "ItemIdentifier{registryId='" + this.registryId + "', name='" + this.name + "', componentsJson='" + this.componentsJson + "'}";
        }
    }
}

