/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyperlightdriftasmodmenu.client.gui;

import net.mcreator.hyperlightdriftasmodmenu.init.HyperlightdriftasModMenuModScreens;
import net.mcreator.hyperlightdriftasmodmenu.network.TeleportButtonMessage;
import net.mcreator.hyperlightdriftasmodmenu.world.inventory.TeleportMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class TeleportScreen
extends AbstractContainerScreen<TeleportMenu>
implements HyperlightdriftasModMenuModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox XCo;
    EditBox YCo;
    EditBox ZCo;
    Button button_teleport;
    Button button_back;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"hyperlightdriftas_mod_menu:textures/screens/teleport.png");

    public TeleportScreen(TeleportMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("XCo")) {
                this.XCo.setValue(stringState);
            } else if (name.equals("YCo")) {
                this.YCo.setValue(stringState);
            } else if (name.equals("ZCo")) {
                this.ZCo.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.XCo.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.YCo.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.ZCo.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.XCo.isFocused()) {
            return this.XCo.keyPressed(key, b, c);
        }
        if (this.YCo.isFocused()) {
            return this.YCo.keyPressed(key, b, c);
        }
        if (this.ZCo.isFocused()) {
            return this.ZCo.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String XCoValue = this.XCo.getValue();
        String YCoValue = this.YCo.getValue();
        String ZCoValue = this.ZCo.getValue();
        super.resize(minecraft, width, height);
        this.XCo.setValue(XCoValue);
        this.YCo.setValue(YCoValue);
        this.ZCo.setValue(ZCoValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.label_teleport"), -199, -112, -10066330, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.label_x"), -145, -58, -10066330, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.label_y"), -4, -58, -10066330, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.label_z"), 138, -57, -10066330, false);
    }

    public void init() {
        super.init();
        this.XCo = new EditBox(this.font, this.leftPos + -199, this.topPos + -30, 118, 18, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.XCo"));
        this.XCo.setMaxLength(8192);
        this.XCo.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "XCo", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.XCo);
        this.YCo = new EditBox(this.font, this.leftPos + -60, this.topPos + -30, 118, 18, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.YCo"));
        this.YCo.setMaxLength(8192);
        this.YCo.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "YCo", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.YCo);
        this.ZCo = new EditBox(this.font, this.leftPos + 81, this.topPos + -30, 118, 18, (Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.ZCo"));
        this.ZCo.setMaxLength(8192);
        this.ZCo.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "ZCo", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.ZCo);
        this.button_teleport = Button.builder((Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.button_teleport"), e -> {
            int x = this.x;
            int y = this.y;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new TeleportButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TeleportButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + -34, this.topPos + 39, 67, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_teleport);
        this.button_back = Button.builder((Component)Component.translatable((String)"gui.hyperlightdriftas_mod_menu.teleport.button_back"), e -> {
            int x = this.x;
            int y = this.y;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new TeleportButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TeleportButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + -208, this.topPos + 95, 46, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_back);
    }
}

