/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyperlightdriftasmodmenu.network;

import net.mcreator.hyperlightdriftasmodmenu.HyperlightdriftasModMenuMod;
import net.mcreator.hyperlightdriftasmodmenu.procedures.ItemsArmourTrimsGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.ItemsDiscsGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.ItemsFoodGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.ItemsMineralsGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.ItemsMiscGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.ItemsWoodGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.MainGUIOpenProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record ItemsListButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ItemsListButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hyperlightdriftas_mod_menu", (String)"items_list_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemsListButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ItemsListButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ItemsListButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ItemsListButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> ItemsListButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MainGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ItemsMineralsGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ItemsWoodGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ItemsFoodGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ItemsMiscGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            ItemsArmourTrimsGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            ItemsDiscsGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HyperlightdriftasModMenuMod.addNetworkMessage(TYPE, STREAM_CODEC, ItemsListButtonMessage::handleData);
    }
}

