/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyperlightdriftasmodmenu.network;

import net.mcreator.hyperlightdriftasmodmenu.HyperlightdriftasModMenuMod;
import net.mcreator.hyperlightdriftasmodmenu.procedures.MainGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.TimeDayProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.TimeMidnightProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.TimeNightProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.TimeNoonProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.TimeSunriseProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.TimeSunsetProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record TimeButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TimeButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hyperlightdriftas_mod_menu", (String)"time_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TimeButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new TimeButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<TimeButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(TimeButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> TimeButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TimeSunriseProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            TimeDayProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            TimeNoonProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            TimeSunsetProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            TimeNightProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 5) {
            TimeMidnightProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 6) {
            MainGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HyperlightdriftasModMenuMod.addNetworkMessage(TYPE, STREAM_CODEC, TimeButtonMessage::handleData);
    }
}

