/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyperlightdriftasmodmenu.network;

import net.mcreator.hyperlightdriftasmodmenu.HyperlightdriftasModMenuMod;
import net.mcreator.hyperlightdriftasmodmenu.procedures.MainGUIOpenProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.RemoveXPLevelsProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.RemoveXPPointsProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.XPlevelsProcedure;
import net.mcreator.hyperlightdriftasmodmenu.procedures.XPpointsProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record XPGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<XPGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hyperlightdriftas_mod_menu", (String)"xpgui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, XPGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new XPGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<XPGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(XPGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> XPGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            XPpointsProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            XPlevelsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            RemoveXPPointsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            RemoveXPLevelsProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            MainGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HyperlightdriftasModMenuMod.addNetworkMessage(TYPE, STREAM_CODEC, XPGUIButtonMessage::handleData);
    }
}

