/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.client.bundle;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.salju.quill.item.component.BundleHoldingTooltip;

public record ClientBundleHoldingTooltip(BundleHoldingTooltip tip) implements ClientTooltipComponent
{
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK = ResourceLocation.fromNamespaceAndPath((String)"quill", (String)"bundle/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT = ResourceLocation.fromNamespaceAndPath((String)"quill", (String)"bundle/slot_highlight_front");

    public int getHeight(Font f) {
        return this.backgroundHeight() + 4;
    }

    public int getWidth(Font f) {
        return this.backgroundWidth();
    }

    public boolean showTooltipWithItemInHand() {
        return true;
    }

    public void renderImage(Font f, int x, int y, int z, int o, GuiGraphics gui) {
        int k = 0;
        if (!this.tip.getContents().isEmpty()) {
            for (int i = 0; i < this.gridSizeY(); ++i) {
                for (int a = 0; a < this.gridSizeX(); ++a) {
                    int e = x + a * 18 + 1;
                    int u = y + i * 20 + 1;
                    this.renderSlot(e, u, k++, gui, f);
                }
            }
        }
    }

    private void renderSlot(int x, int y, int i, GuiGraphics gui, Font f) {
        if (i < this.tip.getContents().size()) {
            if (this.tip.getContents().getSelectedItem() == i) {
                gui.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK, x, y, 18, 18);
            }
            ItemStack stack = this.tip.getContents().getSpecificItem(i);
            gui.renderItem(stack, x + 1, y + 1, i);
            gui.renderItemDecorations(f, stack, x + 1, y + 1);
            if (this.tip.getContents().getSelectedItem() == i) {
                gui.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT, x, y, 18, 18);
            }
        }
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 20 + 2;
    }

    private int gridSizeX() {
        if (this.tip.getContents().isEmpty()) {
            return 0;
        }
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.tip.getContents().size() + 1.0)));
    }

    private int gridSizeY() {
        if (this.tip.getContents().isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((double)this.tip.getContents().size() / (double)this.gridSizeX());
    }
}

