/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.events;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.salju.quill.events.QuillManager;
import net.salju.quill.init.QuillConfig;
import net.salju.quill.init.QuillItems;
import net.salju.quill.init.QuillTags;

@EventBusSubscriber
public class QuillEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        int i;
        Player player = event.getEntity();
        if (!player.getItemBySlot(EquipmentSlot.CHEST).isEmpty() && player.getItemBySlot(EquipmentSlot.CHEST).isEnchanted() && (i = QuillManager.getEnchantmentLevel(player.getItemBySlot(EquipmentSlot.CHEST), player.level(), "quill", "magnetic")) > 0) {
            for (ItemEntity item : player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate((double)((Integer)QuillConfig.MAGRANGE.get() * i)))) {
                if (item.isAlive() && player.isCrouching() && QuillManager.isValidMagneticItem(player, item.getItem())) {
                    item.setNoGravity(true);
                    Vec3 v = player.getEyePosition().subtract(item.position());
                    if (item.level().isClientSide()) {
                        item.yOld = item.getY();
                    }
                    item.setDeltaMovement(item.getDeltaMovement().scale(0.95).add(v.normalize().scale(0.05)));
                    continue;
                }
                item.setNoGravity(false);
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        if (event.getSource().getDirectEntity() != null) {
            Projectile proj;
            Entity direct = event.getSource().getDirectEntity();
            LivingEntity target = event.getEntity();
            if (direct instanceof Projectile && (proj = (Projectile)direct).getPersistentData().getDouble("Sharpshooter").isPresent()) {
                if ((Double)proj.getPersistentData().getDouble("Sharpshooter").get() > 0.0) {
                    double x = (Double)proj.getPersistentData().getDouble("Sharpshooter").get();
                    event.setAmount((float)((double)Math.round(Mth.nextInt((RandomSource)target.getRandom(), (int)7, (int)11)) + 2.5 * x));
                }
            } else if (direct instanceof LivingEntity && target.isUsingItem() && ((Boolean)QuillConfig.USER.get()).booleanValue() && target.getUseItem().getUseDuration(target) <= 64) {
                target.stopUsingItem();
                if (target instanceof Player) {
                    Player player = (Player)target;
                    player.getCooldowns().addCooldown(target.getUseItem(), 12);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDeathDrops(LivingDropsEvent event) {
        Level level;
        Frog frog;
        Entity entity;
        if (event.getEntity().getType().equals(EntityType.MAGMA_CUBE) && (entity = event.getSource().getEntity()) instanceof Frog && (frog = (Frog)entity).getVariant().is(ResourceLocation.fromNamespaceAndPath((String)"quill", (String)"witch")) && (level = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            event.getEntity().spawnAtLocation(lvl, new ItemStack((ItemLike)QuillItems.AZURE.get()));
        }
    }

    @SubscribeEvent
    public static void onProjectile(LivingGetProjectileEvent event) {
        int i = QuillManager.getEnchantmentLevel(event.getProjectileWeaponItemStack(), event.getEntity().level(), "minecraft", "infinity");
        if (i > 0 && event.getProjectileItemStack().isEmpty()) {
            event.setProjectileItemStack(new ItemStack((ItemLike)Items.ARROW));
        }
    }

    @SubscribeEvent
    public static void onBlockAttack(LivingShieldBlockEvent event) {
        if (event.getDamageSource().getDirectEntity() != null && event.getBlocked()) {
            ItemStack stack = event.getEntity().getUseItem();
            Entity entity = event.getDamageSource().getDirectEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                int i = QuillManager.getEnchantmentLevel(stack, target.level(), "quill", "spikes");
                int e = QuillManager.getEnchantmentLevel(stack, target.level(), "quill", "blazing");
                if (i > 0) {
                    LivingEntity livingEntity = event.getEntity();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        float fd = target instanceof Phantom ? (float)i * 2.5f : (float)i;
                        target.hurt(player.damageSources().thorns((Entity)player), fd);
                        Level level = player.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel lvl = (ServerLevel)level;
                            if (fd > 2.0f) {
                                lvl.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.5), target.getZ(), (int)(fd * 0.5f), 0.15, 0.0, 0.15, 0.25);
                            }
                        }
                    } else {
                        float fd = target instanceof Phantom ? (float)i * 2.5f : (float)i;
                        target.hurt(event.getEntity().damageSources().thorns((Entity)event.getEntity()), fd);
                    }
                }
                if (e > 0 && !target.fireImmune()) {
                    target.setRemainingFireTicks(e * 80);
                }
            } else {
                Projectile target;
                int d;
                Entity i = event.getDamageSource().getDirectEntity();
                if (i instanceof Projectile && (d = QuillManager.getEnchantmentLevel(stack, (target = (Projectile)i).level(), "quill", "deflecting")) > 0 && target instanceof Arrow) {
                    double x = Mth.nextDouble((RandomSource)target.getRandom(), (double)-0.15, (double)0.15);
                    double y = Mth.nextDouble((RandomSource)target.getRandom(), (double)-0.07, (double)0.07);
                    Arrow newbie = new Arrow(event.getEntity().level(), event.getEntity(), new ItemStack((ItemLike)Items.ARROW), new ItemStack((ItemLike)Items.BOW));
                    newbie.setCritArrow(true);
                    newbie.setBaseDamage(0.75 * (double)d);
                    newbie.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    newbie.shoot(event.getEntity().getViewVector((float)1.0f).x + x, event.getEntity().getViewVector((float)1.0f).y + y, event.getEntity().getViewVector((float)1.0f).z, 1.9499999f, 1.0f);
                    event.getEntity().level().addFreshEntity((Entity)newbie);
                    target.discard();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawned(MobSpawnEvent.PositionCheck event) {
        if (((Boolean)QuillConfig.CAMPFIRE.get()).booleanValue() && event.getEntity() instanceof Enemy && event.getSpawnType().equals((Object)EntitySpawnReason.NATURAL) && QuillManager.getCampfire(event.getLevel(), event.getEntity().blockPosition(), (Integer)QuillConfig.CAMPRANGE.get())) {
            event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
        }
    }

    @SubscribeEvent
    public static void onTick(EntityTickEvent.Post event) {
        Player player;
        if (event.getEntity().getType().is(QuillTags.RIDERS) && ((Boolean)QuillConfig.TAXI.get()).booleanValue() && (player = event.getEntity().level().getNearestPlayer(event.getEntity(), 6.0)) != null && player.isPassenger()) {
            int i = QuillManager.getMaxRiders(player.getVehicle().getType());
            if (player.getVehicle().getPassengers().size() < i && event.getEntity().distanceTo(player.getVehicle()) <= 1.0f * (float)i) {
                event.getEntity().startRiding(player.getVehicle());
            }
        }
    }

    @SubscribeEvent
    public static void onMobAttack(LivingChangeTargetEvent event) {
        if (event.getEntity().getType().is(QuillTags.PEACEFUL) && ((Boolean)QuillConfig.PEACEFUL.get()).booleanValue() && event.getOriginalAboutToBeSetTarget() instanceof Player && event.getEntity().getLastHurtByMob() != event.getOriginalAboutToBeSetTarget()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobGrief(EntityMobGriefingEvent event) {
        if (event.getEntity().getType().is(QuillTags.NO) && ((Boolean)QuillConfig.NO.get()).booleanValue()) {
            event.setCanGrief(false);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (player.isCrouching() && target.isPassenger() && ((Boolean)QuillConfig.KICK.get()).booleanValue()) {
                player.swing(InteractionHand.MAIN_HAND, true);
                target.stopRiding();
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        block7: {
            CropBlock crops;
            Block block;
            BlockState state;
            BlockPos pos;
            ItemStack stack;
            Level world;
            Player player;
            block5: {
                block6: {
                    player = event.getEntity();
                    world = event.getLevel();
                    stack = event.getItemStack();
                    pos = event.getPos();
                    state = world.getBlockState(pos);
                    if (!((Boolean)QuillConfig.LADDER.get()).booleanValue() || !state.is(QuillTags.LADDERS) || !stack.is(state.getBlock().asItem())) break block5;
                    if (!world.isEmptyBlock(pos.below())) break block6;
                    world.setBlock(pos.below(), state, 3);
                    world.playSound((Entity)player, pos.below(), state.getSoundType((LevelReader)world, pos.below(), (Entity)player).getPlaceSound(), SoundSource.BLOCKS);
                    player.swing(event.getHand());
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    break block7;
                }
                if (!world.isEmptyBlock(pos.above())) break block7;
                world.setBlock(pos.above(), state, 3);
                world.playSound((Entity)player, pos.above(), state.getSoundType((LevelReader)world, pos.above(), (Entity)player).getPlaceSound(), SoundSource.BLOCKS);
                player.swing(event.getHand());
                if (player.isCreative()) break block7;
                stack.shrink(1);
                break block7;
            }
            if (stack.getItem() instanceof HoeItem && ((Boolean)QuillConfig.FARMER.get()).booleanValue() && (block = state.getBlock()) instanceof CropBlock && (crops = (CropBlock)block).isMaxAge(state)) {
                player.swing(event.getHand());
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    lvl.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                    stack.hurtAndBreak(1, (LivingEntity)player, stack.getEquipmentSlot());
                    List drops = CropBlock.getDrops((BlockState)state, (ServerLevel)lvl, (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
                    ItemStack base = crops.getCloneItemStack((LevelReader)lvl, pos, state, true, player);
                    lvl.setBlock(pos, crops.getStateForAge(0), 2);
                    double x = (double)pos.getX() + 0.5;
                    double y = (double)pos.getY() + 0.5;
                    double z = (double)pos.getZ() + 0.5;
                    int f = QuillManager.getEnchantmentLevel(stack, player.level(), "minecraft", "fortune");
                    for (ItemStack item : drops) {
                        if (item.is(Tags.Items.CROPS)) {
                            int i;
                            lvl.addFreshEntity((Entity)new ItemEntity((Level)lvl, x, y, z, item));
                            if (base.get(DataComponents.FOOD) != null || f <= 0 || !(Math.random() <= 0.56) || (i = Mth.nextInt((RandomSource)RandomSource.create(), (int)0, (int)f)) <= 0) continue;
                            item.setCount(i);
                            lvl.addFreshEntity((Entity)new ItemEntity((Level)lvl, x, y, z, item));
                            continue;
                        }
                        if (!item.is(Tags.Items.SEEDS)) continue;
                        item.setCount(1);
                        if (!(Math.random() <= 0.45)) continue;
                        lvl.addFreshEntity((Entity)new ItemEntity((Level)lvl, x, y, z, item));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAttributes(ItemAttributeModifierEvent event) {
        if (((Boolean)QuillConfig.WEAPONS.get()).booleanValue()) {
            if (event.getItemStack().is(QuillTags.SPECIALS)) {
                event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)-2.8f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 7.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            } else if (event.getItemStack().is(QuillTags.AXES)) {
                event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(5.0f + QuillManager.getBonusDamage(event.getItemStack())), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
        }
    }

    @SubscribeEvent
    public static void onGrindstone(GrindstoneEvent.OnPlaceItem event) {
        if (((Boolean)QuillConfig.GRIND.get()).booleanValue() && event.getTopItem().isEnchanted() && event.getBottomItem().is(Items.ENCHANTED_BOOK)) {
            ItemStack stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            ItemEnchantments.Mutable enchs = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)event.getTopItem()));
            ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)event.getBottomItem()));
            int i = 0;
            for (Holder e : map.keySet()) {
                if (e.is(EnchantmentTags.CURSE)) {
                    enchs.set(e, map.getLevel(e));
                    continue;
                }
                i += ((Enchantment)e.value()).getMinCost(map.getLevel(e));
            }
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchs.toImmutable());
            event.setOutput(stack);
            event.setXp(i);
        }
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        if (((Boolean)QuillConfig.REPAIR.get()).booleanValue() && QuillManager.isValidRepairItem(event.getLeft(), event.getRight()) && event.getLeft().isDamaged()) {
            ItemStack stack = event.getLeft().copy();
            int i = stack.getDamageValue() > stack.getMaxDamage() / 2 && event.getRight().getCount() > 1 ? 2 : 1;
            stack.setDamageValue(Math.max(stack.getDamageValue() - stack.getMaxDamage() / 2 * i, 0));
            event.setXpCost(i);
            event.setMaterialCost(i);
            event.setOutput(stack);
        } else if (((Boolean)QuillConfig.ANBOOK.get()).booleanValue() && (event.getLeft().isEnchantable() || event.getLeft().is(Items.ENCHANTED_BOOK) || event.getLeft().isEnchanted()) && (event.getRight().is(Items.ENCHANTED_BOOK) || event.getRight().is(event.getLeft().getItem()) && event.getRight().isEnchanted())) {
            ItemEnchantments.Mutable map = event.getLeft().isEnchanted() || event.getLeft().is(Items.ENCHANTED_BOOK) ? new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)event.getLeft().copy())) : new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            ItemEnchantments.Mutable book = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)event.getRight()));
            int i = 0;
            for (Holder e : book.keySet()) {
                int p = Math.min(map.getLevel(e) == book.getLevel(e) ? book.getLevel(e) + 1 : book.getLevel(e), ((Enchantment)e.value()).getMaxLevel());
                boolean check = event.getLeft().is(Items.ENCHANTED_BOOK) || event.getLeft().supportsEnchantment(e);
                for (Holder target : map.keySet()) {
                    if (e != target && !EnchantmentHelper.isEnchantmentCompatible((Collection)map.keySet(), (Holder)e) || e == target && map.getLevel(e) >= p) {
                        check = false;
                        continue;
                    }
                    if (e != target || map.getLevel(e) >= p) continue;
                    check = true;
                }
                if (!check || !e.is(EnchantmentTags.CURSE) && p <= map.getLevel(e)) continue;
                map.set(e, p);
                i += p * 4 / 2;
            }
            if (i > 0) {
                ItemStack stack = event.getLeft().copy();
                if (event.getName() != null && !StringUtil.isBlank((String)event.getName()) && !event.getName().equals(stack.getHoverName().getString())) {
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)event.getName()));
                }
                if (stack.isEnchanted()) {
                    EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)ItemEnchantments.EMPTY);
                }
                EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)map.toImmutable());
                event.setXpCost(Math.min(i, (Integer)QuillConfig.MAXANBOOKCOST.get()));
                event.setMaterialCost(1);
                event.setOutput(stack);
            } else {
                event.setCanceled(true);
            }
        } else if (((Boolean)QuillConfig.RENAME.get()).booleanValue() && !event.getLeft().isEmpty() && event.getRight().isEmpty() && event.getName() != null && !StringUtil.isBlank((String)event.getName()) && !event.getName().equals(event.getLeft().getHoverName().getString())) {
            ItemStack stack = event.getLeft().copy();
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)event.getName()));
            event.setXpCost(1);
            event.setMaterialCost(1);
            event.setOutput(stack);
        }
    }

    @SubscribeEvent
    public static void onBlockAttack(PlayerInteractEvent.LeftClickBlock event) {
        if (((Boolean)QuillConfig.WEAPONS.get()).booleanValue() && event.getEntity().isCreative() && event.getItemStack().is(QuillTags.AXES)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!event.getTool().isEmpty() && (entity = event.getLevel()) instanceof ServerLevel) {
                Entity lvl = entity;
                ItemStack stack = event.getTool();
                double x = (double)event.getPos().getX() + 0.5;
                double y = (double)event.getPos().getY() + 0.5;
                double z = (double)event.getPos().getZ() + 0.5;
                int i = QuillManager.getEnchantmentLevel(stack, player.level(), "quill", "auto_smelt");
                if (event.getState().is(QuillTags.SMELT) && !player.isCreative() && i > 0) {
                    for (ItemEntity ore : event.getDrops()) {
                        Optional recipe = lvl.getServer().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(ore.getItem()), (Level)lvl);
                        if (!recipe.isPresent()) continue;
                        ItemStack smelt = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).assemble(new SingleRecipeInput(ore.getItem()), (HolderLookup.Provider)lvl.registryAccess());
                        smelt.setCount(ore.getItem().getCount());
                        lvl.addFreshEntity((Entity)new ItemEntity((Level)lvl, x, y, z, smelt));
                        if (event.isCanceled()) continue;
                        lvl.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 4, 0.35, 0.35, 0.35, 0.0);
                        lvl.addFreshEntity((Entity)new ExperienceOrb((Level)lvl, x, y, z, 2));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

