/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.salju.quill.init.QuillData;
import net.salju.quill.item.component.BundleHoldingContents;
import net.salju.quill.item.component.BundleHoldingTooltip;

public class BundleHoldingItem
extends Item {
    public BundleHoldingItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, list, flag);
        list.accept((Component)Component.translatable((String)"item.quill.bundle.fullness", (Object[])new Object[]{this.getContentWeight(stack), 256}).withStyle(ChatFormatting.GRAY));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new BundleHoldingTooltip((BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY)));
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY);
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getContentWeight(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.min(1 + 12 * this.getContentWeight(stack) / 256, 13);
    }

    public int getBarColor(ItemStack stack) {
        return 0x6666FF;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void inventoryTick(ItemStack stack, ServerLevel lvl, Entity target, EquipmentSlot slot) {
        super.inventoryTick(stack, lvl, target, slot);
        BundleHoldingContents data = (BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY);
        if (EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.CURSE) && !data.isEmpty()) {
            data.getItems().clear();
        }
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack target = slot.getItem();
        if (!target.isEmpty() && EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.CURSE)) {
            this.playSound((Entity)player, SoundEvents.BUNDLE_INSERT);
            target.shrink(target.getCount());
        } else if (target.isEmpty() && this.getContentWeight(stack) > 0) {
            int i = this.getSelectedItem(stack);
            ItemStack newstack = this.removeOne(stack, i != -1 ? i : 0);
            if (!newstack.isEmpty()) {
                this.playSound((Entity)player, SoundEvents.BUNDLE_REMOVE_ONE);
                this.add(stack, slot.safeInsert(newstack));
            }
        } else if (target.getItem().canFitInsideContainerItems()) {
            int i = 256 - this.getContentWeight(stack);
            if (this.add(stack, slot.safeTake(target.getCount(), i, player))) {
                this.playSound((Entity)player, SoundEvents.BUNDLE_INSERT);
            }
        }
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack target, Slot slot, ClickAction action, Player player, SlotAccess acc) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (slot.allowModification(player)) {
            if (!target.isEmpty() && EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.CURSE)) {
                this.playSound((Entity)player, SoundEvents.BUNDLE_INSERT);
                target.shrink(target.getCount());
            } else if (target.isEmpty()) {
                int i = this.getSelectedItem(stack);
                ItemStack newstack = this.removeOne(stack, i != -1 ? i : 0);
                if (!newstack.isEmpty()) {
                    this.playSound((Entity)player, SoundEvents.BUNDLE_REMOVE_ONE);
                    acc.set(newstack);
                }
            } else if (target.getItem().canFitInsideContainerItems()) {
                int i = 256 - this.getContentWeight(stack);
                if (this.add(stack, target)) {
                    this.playSound((Entity)player, SoundEvents.BUNDLE_INSERT);
                    target.shrink(i);
                }
            }
            return true;
        }
        return false;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.dropContents(stack, (Entity)player)) {
            this.playSound((Entity)player, SoundEvents.BUNDLE_DROP_CONTENTS);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public int getMatchingItem(ItemStack stack, List<ItemStack> data) {
        if (!stack.isStackable()) {
            return -1;
        }
        for (int i = 0; i < data.size(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)data.get(i), (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public boolean add(ItemStack stack, ItemStack item) {
        if (!item.isEmpty() && item.getItem().canFitInsideContainerItems()) {
            ArrayList<ItemStack> data = new ArrayList<ItemStack>(this.getContents(stack));
            if (this.getContentWeight(stack) >= 256) {
                return false;
            }
            int i = this.getMatchingItem(item, data);
            if (i != -1) {
                if (((ItemStack)data.get(i)).getCount() >= ((ItemStack)data.get(i)).getMaxStackSize()) {
                    data.addFirst(item.copyWithCount(item.getCount() + this.getContentWeight(stack) > 256 ? 256 - this.getContentWeight(stack) : item.getCount()));
                } else {
                    int c = ((ItemStack)data.get(i)).getCount() + item.getCount();
                    if (c > ((ItemStack)data.get(i)).getMaxStackSize()) {
                        ItemStack copy;
                        data.addFirst(copy.copyWithCount((copy = ((ItemStack)data.remove(i)).copyWithCount(item.getMaxStackSize())).getCount() + this.getContentWeight(stack) > 256 ? 256 - this.getContentWeight(stack) : copy.getCount()));
                        data.addFirst(item.copyWithCount(item.getCount() + this.getContentWeight(stack) > 256 ? 256 - this.getContentWeight(stack) : c - item.getMaxStackSize()));
                    } else {
                        ItemStack copy = (ItemStack)data.remove(i);
                        copy.grow(item.getCount());
                        data.addFirst(copy);
                    }
                }
            } else {
                data.addFirst(item.copyWithCount(item.getCount() + this.getContentWeight(stack) > 256 ? 256 - this.getContentWeight(stack) : item.getCount()));
            }
            stack.set(QuillData.BUNDLE, (Object)new BundleHoldingContents(data));
            return true;
        }
        return false;
    }

    public boolean dropContents(ItemStack stack, Entity target) {
        BundleHoldingContents data = (BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY);
        if (data.isEmpty()) {
            return false;
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer ply = (ServerPlayer)target;
            data.getItemsAsCopyIterable().forEach(item -> ply.drop(item, true));
        }
        stack.set(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY);
        return true;
    }

    public ItemStack removeOne(ItemStack stack, int i) {
        ArrayList<ItemStack> data = new ArrayList<ItemStack>(this.getContents(stack));
        if (data.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack newstack = (ItemStack)data.remove(i);
        stack.set(QuillData.BUNDLE, (Object)new BundleHoldingContents(data));
        return newstack;
    }

    public List<ItemStack> getContents(ItemStack stack) {
        return ((BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY)).getItems();
    }

    public int getContentWeight(ItemStack stack) {
        return ((BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY)).getWeight();
    }

    public int getSelectedItem(ItemStack stack) {
        return ((BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY)).getSelectedItem();
    }

    public void playSound(Entity target, SoundEvent sound) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            lvl.playSound(null, target.blockPosition(), sound, SoundSource.AMBIENT, 1.0f, 0.8f + lvl.getRandom().nextFloat() * 0.4f);
        } else {
            target.playSound(sound, 0.8f, 0.8f + target.level().getRandom().nextFloat() * 0.4f);
        }
    }

    public static boolean hasSelectedItem(ItemStack stack) {
        BundleHoldingContents data = (BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY);
        return data.getSelectedItem() >= 0;
    }

    public static ItemStack getSelectedItemStack(ItemStack stack) {
        BundleHoldingContents data = (BundleHoldingContents)stack.getOrDefault(QuillData.BUNDLE, (Object)BundleHoldingContents.EMPTY);
        if (data.getSelectedItem() >= 0) {
            return data.getSpecificItem(data.getSelectedItem());
        }
        return ItemStack.EMPTY;
    }
}

