/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.item;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.salju.quill.init.QuillData;
import net.salju.quill.item.component.MagicMirrorTeleport;

public class MagicMirrorItem
extends Item {
    public MagicMirrorItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, list, flag);
        MagicMirrorTeleport data = (MagicMirrorTeleport)stack.getOrDefault(QuillData.TELEPORT, (Object)MagicMirrorTeleport.EMPTY);
        list.accept((Component)Component.literal((String)(data.getPos().getX() + ", " + data.getPos().getY() + ", " + data.getPos().getZ())).withStyle(ChatFormatting.DARK_PURPLE));
    }

    public int getUseDuration(ItemStack stack, LivingEntity target) {
        return 64;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(QuillData.TELEPORT, (Object)MagicMirrorTeleport.EMPTY);
        return stack;
    }

    public void inventoryTick(ItemStack stack, ServerLevel lvl, Entity target, EquipmentSlot slot) {
        super.inventoryTick(stack, lvl, target, slot);
        MagicMirrorTeleport data = (MagicMirrorTeleport)stack.getOrDefault(QuillData.TELEPORT, (Object)MagicMirrorTeleport.EMPTY);
        if (target instanceof ServerPlayer) {
            ServerPlayer ply = (ServerPlayer)target;
            if (ply.getRespawnConfig() == null) {
                if (!BlockPos.containing((double)data.getPos().getX(), (double)data.getPos().getY(), (double)data.getPos().getZ()).equals((Object)lvl.getLevelData().getRespawnData().pos())) {
                    stack.set(QuillData.TELEPORT, (Object)new MagicMirrorTeleport(Optional.of(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)lvl.getLevelData().getRespawnData().pos()))));
                }
            } else if (!BlockPos.containing((double)data.getPos().getX(), (double)data.getPos().getY(), (double)data.getPos().getZ()).equals((Object)ply.getRespawnConfig().respawnData().pos())) {
                stack.set(QuillData.TELEPORT, (Object)new MagicMirrorTeleport(Optional.of(GlobalPos.of((ResourceKey)ply.getRespawnConfig().respawnData().dimension(), (BlockPos)ply.getRespawnConfig().respawnData().pos()))));
            }
        }
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity target, int i) {
        MagicMirrorTeleport data = (MagicMirrorTeleport)stack.getOrDefault(QuillData.TELEPORT, (Object)MagicMirrorTeleport.EMPTY);
        if (i <= 10 && target instanceof ServerPlayer) {
            ServerPlayer ply = (ServerPlayer)target;
            if (world instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)world;
                if (data.target().isPresent()) {
                    double x = (double)data.getPos().getX() + 0.5;
                    double y = (double)data.getPos().getY() + (ply.getRespawnConfig() != null ? 0.7 : 0.0);
                    double z = (double)data.getPos().getZ() + 0.5;
                    ServerLevel loc = lvl.getServer().getLevel(data.target().get().dimension());
                    if (loc != null) {
                        lvl.playSound(null, ply.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                        lvl.sendParticles((ParticleOptions)ParticleTypes.PORTAL, ply.getX(), ply.getY(), ply.getZ(), 12, 0.5, 0.5, 0.5, 0.65);
                        ply.teleport(new TeleportTransition(loc, new Vec3(x, y, z), ply.getDeltaMovement(), ply.getYRot(), ply.getXRot(), TeleportTransition.DO_NOTHING));
                        loc.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                        loc.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 12, 0.5, 0.5, 0.5, 0.65);
                    }
                    ply.getCooldowns().addCooldown(stack, 200);
                }
            }
        }
        return super.releaseUsing(stack, world, target, i);
    }

    public void onUseTick(Level world, LivingEntity target, ItemStack stack, int i) {
        super.onUseTick(world, target, stack, i);
        if (world instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)world;
            if (i <= 1) {
                this.releaseUsing(stack, world, target, i);
            } else {
                lvl.sendParticles((ParticleOptions)ParticleTypes.PORTAL, target.getX(), target.getY(), target.getZ(), 1, 0.5, 0.5, 0.5, 0.65);
            }
        }
    }
}

