/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.mixins;

import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.salju.quill.events.QuillManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrushableBlockEntity.class})
public abstract class BrushableBlockEntityMixin {
    @Shadow
    private int brushCount;

    @Inject(method={"brush"}, at={@At(value="HEAD")})
    public void speed(long time, ServerLevel lvl, LivingEntity target, Direction dir, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        int e = QuillManager.getEnchantmentLevel(stack, (Level)lvl, "minecraft", "efficiency");
        if (e > 0 && this.brushCount <= e * 2) {
            ++this.brushCount;
            if (e >= 4) {
                ++this.brushCount;
            }
        }
    }
}

