/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.mixins;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.salju.quill.init.QuillConfig;
import net.salju.quill.init.QuillSounds;
import net.salju.quill.network.Fireworks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Creeper.class})
public abstract class CreeperMixin {
    @Inject(method={"explodeCreeper"}, at={@At(value="HEAD")}, cancellable=true)
    private void boom(CallbackInfo ci) {
        if (((Boolean)QuillConfig.CREEPER.get()).booleanValue()) {
            Creeper creeper = (Creeper)this;
            float f = creeper.isPowered() ? 2.0f : 1.0f;
            Level level = creeper.level();
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                lvl.playSound(null, creeper.blockPosition(), SoundEvents.FIREWORK_ROCKET_TWINKLE, SoundSource.HOSTILE, 1.0f, 1.0f);
                if (creeper.isPowered() || Math.random() <= 0.12) {
                    lvl.playSound(null, creeper.blockPosition(), (SoundEvent)QuillSounds.CHEERS.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                PacketDistributor.sendToPlayersNear((ServerLevel)lvl, null, (double)creeper.getX(), (double)creeper.getY(), (double)creeper.getZ(), (double)32.0, (CustomPacketPayload)new Fireworks(creeper.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                WeightedList list = WeightedList.builder().build();
                lvl.explode((Entity)creeper, Explosion.getDefaultDamageSource((Level)lvl, (Entity)creeper), null, creeper.getX(), creeper.getY(), creeper.getZ(), 3.0f * f, false, Level.ExplosionInteraction.NONE, (ParticleOptions)ParticleTypes.CRIT, (ParticleOptions)ParticleTypes.CRIT, list, QuillSounds.EMPTY);
                this.spawnLingeringCloud();
                creeper.discard();
            }
            ci.cancel();
        }
    }

    @Shadow
    abstract void spawnLingeringCloud();
}

