/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.mixins;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.salju.quill.events.QuillManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    @Inject(method={"createProjectile"}, at={@At(value="RETURN")})
    private void onGetArrow(Level level, LivingEntity shooter, ItemStack crossbow, ItemStack ammo, boolean critical, CallbackInfoReturnable<AbstractArrow> ci) {
        Object object = ci.getReturnValue();
        if (object instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)object;
            int s = QuillManager.getEnchantmentLevel(crossbow, shooter.level(), "quill", "sharpshooter");
            arrow.getPersistentData().putDouble("Sharpshooter", (double)s);
        }
    }
}

