/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.mixins;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.salju.quill.init.QuillConfig;
import net.salju.quill.init.QuillTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"getMaxStackSize"}, at={@At(value="RETURN")}, cancellable=true)
    public void getMax(CallbackInfoReturnable<Integer> ci) {
        ItemStack stack;
        if (((Boolean)QuillConfig.POTS.get()).booleanValue() && (stack = (ItemStack)this).getItem() instanceof PotionItem) {
            ci.setReturnValue((Object)16);
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="RETURN")}, cancellable=true)
    public void isEnchantable(CallbackInfoReturnable<Boolean> ci) {
        ItemStack stack = (ItemStack)this;
        if (stack.is(QuillTags.ENCHS) && !stack.isEnchanted()) {
            if (!stack.has(DataComponents.ENCHANTABLE)) {
                stack.set(DataComponents.ENCHANTABLE, (Object)new Enchantable(1));
            }
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isDamageableItem"}, at={@At(value="RETURN")}, cancellable=true)
    public void isUnbreakable(CallbackInfoReturnable<Boolean> ci) {
        ItemStack stack = (ItemStack)this;
        if (stack.isEnchanted()) {
            if (((Boolean)QuillConfig.UNBREAKABLE.get()).booleanValue()) {
                ci.setReturnValue((Object)false);
            } else if (((Boolean)QuillConfig.UNBREAKING.get()).booleanValue()) {
                ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack.copy()));
                for (Holder e : map.keySet()) {
                    if (!e.is(Enchantments.UNBREAKING)) continue;
                    ci.setReturnValue((Object)false);
                    break;
                }
            }
        }
    }
}

