/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.mixins;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.salju.quill.init.QuillConfig;
import net.salju.quill.init.QuillWitch;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Witch.class})
public abstract class WitchMixin {
    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void step(CallbackInfo ci) {
        Witch hag;
        Level level;
        if (((Boolean)QuillConfig.FROGGO.get()).booleanValue() && (level = (hag = (Witch)this).level()) instanceof ServerLevel) {
            Villager trader;
            ServerLevel lvl = (ServerLevel)level;
            if (hag.isAlive() && (trader = (Villager)lvl.getNearestEntity(Villager.class, TargetingConditions.DEFAULT, (LivingEntity)hag, hag.getX(), hag.getY(), hag.getZ(), hag.getBoundingBox().inflate(12.85))) != null && trader.getVillagerData().profession().is(VillagerProfession.NITWIT)) {
                hag.setTarget((LivingEntity)trader);
            }
        }
    }

    @Inject(method={"performRangedAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void potion(LivingEntity target, float f1, CallbackInfo ci) {
        if (((Boolean)QuillConfig.FROGGO.get()).booleanValue()) {
            Villager trader;
            Witch hag = (Witch)this;
            if (target instanceof Villager && (trader = (Villager)target).getVillagerData().profession().is(VillagerProfession.NITWIT) && !hag.isDrinkingPotion()) {
                double d0 = trader.getX() + trader.getDeltaMovement().x - hag.getX();
                double d1 = trader.getEyeY() - (double)1.1f - hag.getY();
                double d2 = trader.getZ() + trader.getDeltaMovement().z - hag.getZ();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                Level level = hag.level();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    Projectile.spawnProjectileUsingShoot(ThrownSplashPotion::new, (ServerLevel)lvl, (ItemStack)PotionContents.createItemStack((Item)Items.SPLASH_POTION, QuillWitch.FROG), (LivingEntity)hag, (double)d0, (double)(d1 + d3 * 0.2), (double)d2, (float)0.75f, (float)8.0f);
                }
                if (!hag.isSilent()) {
                    hag.level().playSound(null, hag.getX(), hag.getY(), hag.getZ(), SoundEvents.WITCH_THROW, hag.getSoundSource(), 1.0f, 0.8f + hag.getRandom().nextFloat() * 0.4f);
                }
                hag.setTarget(null);
                ci.cancel();
            }
        }
    }
}

