/*
 * Decompiled with CFR 0.152.
 */
package net.salju.quill.network;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.salju.quill.events.QuillClientManager;

public record Fireworks(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<Fireworks> CREEPER_FIREWORKS = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"quill", (String)"creeper_fireworks"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Fireworks> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeBlockPos(message.pos), buffer -> new Fireworks(buffer.readBlockPos()));

    public CustomPacketPayload.Type<Fireworks> type() {
        return CREEPER_FIREWORKS;
    }

    public static void handleData(Fireworks message, IPayloadContext context) {
        Level level;
        if (context.flow() == PacketFlow.CLIENTBOUND && (level = context.player().level()) instanceof ClientLevel) {
            ClientLevel lvl = (ClientLevel)level;
            QuillClientManager.creeperFireworks(lvl, message.pos.getX(), message.pos.getY(), message.pos.getZ());
        }
    }
}

