/*
 * Decompiled with CFR 0.152.
 */
package com.sculkdragonutils.sculkdragonutilsmod;

import com.sculkdragonutils.sculkdragonutilsmod.common.packet.SculkShaderPacket;
import com.sculkdragonutils.sculkdragonutilsmod.common.util.SculkBloomInst;
import com.sculkdragonutils.sculkdragonutilsmod.common.util.ShaderUtil;
import com.sculkdragonutils.sculkdragonutilsmod.effect.ModEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class EventHandler {
    private static final List<SculkBloomInst> blooms = new ArrayList<SculkBloomInst>();
    private static final List<SculkBloomInst> toRemove = new ArrayList<SculkBloomInst>();

    @SubscribeEvent
    public void onShriek(VanillaGameEvent event) {
        Holder vanilla_event = event.getVanillaEvent();
        if (vanilla_event == GameEvent.SHRIEK) {
            MobEffectInstance effectinstance = new MobEffectInstance(ModEffects.REVERBERATING_EFFECT, 80, 0, false, false, true);
            ServerLevel level = (ServerLevel)event.getLevel();
            MobEffectUtil.addEffectToPlayersAround((ServerLevel)level, (Entity)event.getCause(), (Vec3)event.getEventPosition(), (double)16.0, (MobEffectInstance)effectinstance, (int)80);
        }
    }

    @SubscribeEvent
    public void onEffectAdded(MobEffectEvent.Added event) {
        Level level = event.getEntity().level();
        if (event.getEffectInstance().is(ModEffects.SCULK_SIGHT_EFFECT)) {
            LivingEntity livingEntity;
            if (event.getEntity().hasEffect(ModEffects.SCULK_SIGHT_EFFECT)) {
                return;
            }
            if (level.isClientSide() && event.getEntity() instanceof LocalPlayer) {
                ShaderUtil.loadAndCloseUnsafe("sobel.json", false);
            }
            if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SculkShaderPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public void onEffectRemoved(MobEffectEvent.Remove event) {
        Level level = event.getEntity().level();
        if (event.getEffect().is(ModEffects.SCULK_SIGHT_EFFECT)) {
            LivingEntity livingEntity;
            if (level.isClientSide() && event.getEntity() instanceof LocalPlayer) {
                ShaderUtil.loadAndCloseUnsafe("null", true);
            }
            if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SculkShaderPacket(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public void onEffectExpired(MobEffectEvent.Expired event) {
        Level level = event.getEntity().level();
        assert (event.getEffectInstance() != null);
        if (event.getEffectInstance().is(ModEffects.SCULK_SIGHT_EFFECT)) {
            LivingEntity livingEntity;
            if (level.isClientSide() && event.getEntity() instanceof LocalPlayer) {
                ShaderUtil.loadAndCloseUnsafe("null", true);
            }
            if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SculkShaderPacket(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public void onExpDrop(LivingExperienceDropEvent event) {
        int exp = event.getDroppedExperience();
        Player player = event.getAttackingPlayer();
        if (player != null && player.hasEffect(ModEffects.SCULK_BLOOM_EFFECT) && exp < 50) {
            LivingEntity target = event.getEntity();
            BlockPos target_loc = target.blockPosition();
            Level level = target.level();
            if (SculkBloomInst.canSpreadFrom((LevelAccessor)level, target_loc)) {
                if (!level.isClientSide()) {
                    float potency = 1.0f + (float)Objects.requireNonNull(player.getEffect(ModEffects.SCULK_BLOOM_EFFECT)).getAmplifier() * 0.1f;
                    FoodData player_food = player.getFoodData();
                    player_food.eat(Mth.floor((float)(2.0f * potency)), 0.1f * potency);
                    SculkBloomInst newInst = new SculkBloomInst((ServerLevel)level, target_loc.getCenter(), null, false);
                    newInst.bloomParticles(player.blockPosition().getCenter());
                    newInst.addCursors(Mth.floor((float)((float)exp * potency)), 1);
                    EventHandler.addBloom(newInst);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        for (SculkBloomInst bloomInst : blooms) {
            bloomInst.update();
            if (!bloomInst.isDone()) continue;
            bloomInst.clear();
            toRemove.add(bloomInst);
        }
        for (SculkBloomInst doneInst : toRemove) {
            blooms.remove(doneInst);
        }
        toRemove.clear();
    }

    public static void addBloom(SculkBloomInst bloomInst) {
        blooms.add(bloomInst);
    }
}

