/*
 * Decompiled with CFR 0.152.
 */
package com.sculkdragonutils.sculkdragonutilsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sculkdragonutils.sculkdragonutilsmod.EventHandler;
import com.sculkdragonutils.sculkdragonutilsmod.common.util.SculkBloomInst;
import java.util.EnumSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class SculkBloomCommand {
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sculk-bloom").requires(sourceStack -> sourceStack.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"at", (ArgumentType)Vec3Argument.vec3()).executes(command -> SculkBloomCommand.bloomCommand((CommandSourceStack)command.getSource(), Vec3Argument.getCoordinates((CommandContext)command, (String)"at"), 1, 1, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"charge", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(command -> SculkBloomCommand.bloomCommand((CommandSourceStack)command.getSource(), Vec3Argument.getCoordinates((CommandContext)command, (String)"at"), IntegerArgumentType.getInteger((CommandContext)command, (String)"charge"), 1, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"cursors", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(command -> SculkBloomCommand.bloomCommand((CommandSourceStack)command.getSource(), Vec3Argument.getCoordinates((CommandContext)command, (String)"at"), IntegerArgumentType.getInteger((CommandContext)command, (String)"charge"), IntegerArgumentType.getInteger((CommandContext)command, (String)"cursors"), false))).then(Commands.argument((String)"worldgen", (ArgumentType)BoolArgumentType.bool()).executes(command -> SculkBloomCommand.bloomCommand((CommandSourceStack)command.getSource(), Vec3Argument.getCoordinates((CommandContext)command, (String)"at"), IntegerArgumentType.getInteger((CommandContext)command, (String)"charge"), IntegerArgumentType.getInteger((CommandContext)command, (String)"cursors"), BoolArgumentType.getBool((CommandContext)command, (String)"worldgen"))))))));
    }

    private static int bloomCommand(CommandSourceStack source, Coordinates at, int charge, int cursors, boolean worldgen) throws CommandSyntaxException {
        Vec3 vec3 = at.getPosition(source);
        ServerLevel level = source.getLevel();
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (at.isXRelative()) {
            set.add(RelativeMovement.X);
        }
        if (at.isYRelative()) {
            set.add(RelativeMovement.Y);
        }
        if (at.isZRelative()) {
            set.add(RelativeMovement.Z);
        }
        SculkBloomInst bloomInst = new SculkBloomInst(level, vec3, set, worldgen);
        bloomInst.bloomParticles(null);
        bloomInst.addCursors(charge, cursors);
        EventHandler.addBloom(bloomInst);
        return 0;
    }
}

