/*
 * Decompiled with CFR 0.152.
 */
package com.sculkdragonutils.sculkdragonutilsmod.common.util;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SculkBloomInst {
    private final ServerLevel level;
    private final SculkSpreader sculkSpreader;
    private final RandomSource randomsource;
    private final BlockPos blockpos;
    private final Vec3 vec3;
    @Nullable
    private final Set<RelativeMovement> set;

    public SculkBloomInst(ServerLevel level, Vec3 vec3, @Nullable Set<RelativeMovement> set, boolean worldgen) {
        this.level = level;
        this.vec3 = vec3;
        this.set = set;
        this.blockpos = BlockPos.containing((Position)vec3);
        this.sculkSpreader = !worldgen ? SculkSpreader.createLevelSpreader() : SculkSpreader.createWorldGenSpreader();
        this.randomsource = level.getRandom();
    }

    public void addCursors(int charge, int cursorNum) {
        for (int k = 0; k < cursorNum; ++k) {
            this.sculkSpreader.addCursors(this.blockpos, charge);
        }
    }

    public void bloomParticles(@Nullable Vec3 pos) {
        BlockPos blockAt;
        Vec3 loc;
        if (pos != null) {
            loc = pos;
            blockAt = BlockPos.containing((Position)pos);
        } else {
            loc = this.vec3;
            blockAt = this.blockpos;
        }
        this.level.sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, loc.x, loc.y, loc.z, 2, 0.0, 0.0, 0.0, 0.0);
        this.level.playSound(null, blockAt, SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.BLOCKS, 2.0f, 0.6f + this.randomsource.nextFloat() * 0.4f);
    }

    public boolean isDone() {
        int totalCharge = 0;
        for (SculkSpreader.ChargeCursor cursor : this.sculkSpreader.getCursors()) {
            totalCharge += cursor.getCharge();
        }
        return totalCharge <= 0;
    }

    public void clear() {
        this.sculkSpreader.clear();
    }

    public void update() {
        this.sculkSpreader.updateCursors((LevelAccessor)this.level, this.blockpos, this.randomsource, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canSpreadFrom(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.getBlock() instanceof SculkBehaviour) {
            return true;
        }
        if (!blockstate.isAir() && !blockstate.is(BlockTags.REPLACEABLE_BY_TREES)) {
            if (!blockstate.is(Blocks.WATER)) return false;
            if (!blockstate.getFluidState().isSource()) return false;
        }
        boolean bl = true;
        boolean block_valid = bl;
        if (!block_valid) return false;
        if (!Direction.stream().map(arg_0 -> ((BlockPos)pos).relative(arg_0)).anyMatch(blockiter -> level.getBlockState(blockiter).isCollisionShapeFullBlock((BlockGetter)level, blockiter))) return false;
        return true;
    }
}

