/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.item.registry;

import com.cerbon.cerbons_api.api.item.enums.ToolType;
import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistries;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;

public class ItemRegistry {
    private final String modId;
    private final ResourcefulRegistry<Item> itemRegistry;

    public ItemRegistry(String modId) {
        this.modId = modId;
        this.itemRegistry = ResourcefulRegistries.create(BuiltInRegistries.ITEM, modId);
    }

    public Map<ArmorType, RegistryEntry<Item>> registerFullArmorSet(ArmorMaterial material) {
        return this.registerFullArmorSet(material, properties -> properties);
    }

    public Map<ArmorType, RegistryEntry<Item>> registerFullArmorSet(ArmorMaterial material, UnaryOperator<Item.Properties> itemProperties) {
        return ImmutableMap.of((Object)ArmorType.HELMET, this.registerArmor(ArmorType.HELMET, material, itemProperties), (Object)ArmorType.CHESTPLATE, this.registerArmor(ArmorType.CHESTPLATE, material, itemProperties), (Object)ArmorType.LEGGINGS, this.registerArmor(ArmorType.LEGGINGS, material, itemProperties), (Object)ArmorType.BOOTS, this.registerArmor(ArmorType.BOOTS, material, itemProperties));
    }

    public RegistryEntry<Item> registerArmor(ArmorType armorType, ArmorMaterial material) {
        return this.registerArmor(armorType, material, properties -> properties);
    }

    public RegistryEntry<Item> registerArmor(ArmorType armorType, ArmorMaterial material, UnaryOperator<Item.Properties> itemProperties) {
        String materialName = material.assetId().location().getPath();
        String id = materialName + "_" + armorType.getSerializedName();
        return this.registerItem(() -> new Item(((Item.Properties)itemProperties.apply(new Item.Properties().humanoidArmor(material, armorType))).setId(this.makeId(id))), id);
    }

    public RegistryEntry<Item> registerTool(ToolType toolType, ToolMaterial toolMaterial, float attackDamage, float attackSpeed, String id) {
        return this.registerTool(toolType, toolMaterial, properties -> properties, attackDamage, attackSpeed, id);
    }

    public RegistryEntry<Item> registerTool(ToolType toolType, ToolMaterial toolMaterial, UnaryOperator<Item.Properties> itemProperties, float attackDamage, float attackSpeed, String id) {
        return switch (toolType) {
            default -> throw new MatchException(null, null);
            case ToolType.SWORD -> this.registerItem(() -> new Item((Item.Properties)itemProperties.apply(new Item.Properties().sword(toolMaterial, attackDamage, attackSpeed).setId(this.makeId(id)))), id);
            case ToolType.PICKAXE -> this.registerItem(() -> new Item((Item.Properties)itemProperties.apply(new Item.Properties().pickaxe(toolMaterial, attackDamage, attackSpeed).setId(this.makeId(id)))), id);
            case ToolType.AXE -> this.registerItem(() -> new Item((Item.Properties)itemProperties.apply(new Item.Properties().axe(toolMaterial, attackDamage, attackSpeed).setId(this.makeId(id)))), id);
            case ToolType.SHOVEL -> this.registerItem(() -> new Item((Item.Properties)itemProperties.apply(new Item.Properties().shovel(toolMaterial, attackDamage, attackSpeed).setId(this.makeId(id)))), id);
            case ToolType.HOE -> this.registerItem(() -> new Item((Item.Properties)itemProperties.apply(new Item.Properties().hoe(toolMaterial, attackDamage, attackSpeed).setId(this.makeId(id)))), id);
        };
    }

    public RegistryEntry<Item> registerFood(FoodProperties foodProperties, String id) {
        return this.registerFood(foodProperties, properties -> properties, id);
    }

    public RegistryEntry<Item> registerFood(FoodProperties foodProperties, UnaryOperator<Item.Properties> itemProperties, String id) {
        return this.registerItem((Item.Properties)itemProperties.apply(new Item.Properties().food(foodProperties)), id);
    }

    public RegistryEntry<BlockItem> registerBlockItem(Supplier<Block> block, String id) {
        return this.registerBlockItem(block, new Item.Properties(), id);
    }

    public RegistryEntry<BlockItem> registerBlockItem(Supplier<Block> block, Item.Properties itemProperties, String id) {
        return this.registerBlockItem(id, () -> new BlockItem((Block)block.get(), itemProperties.setId(this.makeId(id))));
    }

    public RegistryEntry<BlockItem> registerBlockItem(String id, Supplier<BlockItem> blockItem) {
        return this.registerItem(blockItem, id);
    }

    public RegistryEntry<Item> registerItem(String id) {
        return this.registerItem(new Item.Properties(), id);
    }

    public RegistryEntry<Item> registerItem(Item.Properties itemProperties, String id) {
        return this.registerItem(() -> new Item(itemProperties.setId(this.makeId(id))), id);
    }

    public <T extends Item> RegistryEntry<T> registerItem(Supplier<T> item, String id) {
        return this.itemRegistry.register(id, item);
    }

    public ResourceKey<Item> makeId(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id));
    }

    public Collection<RegistryEntry<Item>> getEntries() {
        return this.itemRegistry.getEntries();
    }

    public Stream<RegistryEntry<Item>> stream() {
        return this.itemRegistry.stream();
    }

    public Stream<Item> boundStream() {
        return this.itemRegistry.boundStream();
    }

    public void register() {
        this.itemRegistry.register();
    }
}

