/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.static_utilities;

import com.cerbon.cerbons_api.api.general.math.ReferencedAxisRotator;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MathUtils {
    public static boolean withinDistance(Vec3 pos1, Vec3 pos2, double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance cannot be negative");
        }
        return pos1.distanceToSqr(pos2) < Math.pow(distance, 2.0);
    }

    public static boolean movingTowards(Vec3 center, Vec3 pos, Vec3 direction) {
        Vec3 directionTo = MathUtils.unNormedDirection(pos, center);
        return direction.dot(directionTo) > 0.0;
    }

    public static Vec3 unNormedDirection(Vec3 source, Vec3 target) {
        return target.subtract(source);
    }

    public static void lineCallback(Vec3 start, Vec3 end, int points, BiConsumer<Vec3, Integer> callback) {
        Vec3 dir = end.subtract(start).scale(1.0 / (double)(points - 1));
        Vec3 pos = start;
        for (int i = 0; i < points; ++i) {
            callback.accept(pos, i);
            pos = pos.add(dir);
        }
    }

    public static void circleCallback(double radius, int points, Vec3 axis, Consumer<Vec3> callback) {
        double degrees = Math.PI * 2 / (double)points;
        double axisYaw = MathUtils.directionToYaw(axis);
        ReferencedAxisRotator rotator = new ReferencedAxisRotator(VecUtils.yAxis, axis);
        for (int i = 0; i < points; ++i) {
            double radians = (double)i * degrees;
            Vec3 offset = VecUtils.rotateVector(new Vec3(Math.sin(radians), 0.0, Math.cos(radians)).scale(radius), VecUtils.yAxis, -axisYaw);
            Vec3 rotated = rotator.rotate(offset);
            callback.accept(rotated);
        }
    }

    public static Collection<Vec3> circlePoints(double radius, int points, Vec3 axis) {
        ArrayList<Vec3> vectors = new ArrayList<Vec3>();
        MathUtils.circleCallback(radius, points, axis, vectors::add);
        return vectors;
    }

    public static boolean willAABBFit(AABB aabb, Vec3 movement, Predicate<AABB> collision) {
        AtomicBoolean collided = new AtomicBoolean(false);
        int points = (int)Math.ceil(movement.length() / aabb.getSize());
        MathUtils.lineCallback(Vec3.ZERO, movement, points, (vec3, integer) -> {
            if (collision.test(aabb.move(vec3))) {
                collided.set(true);
            }
        });
        return !collided.get();
    }

    public static float directionToPitch(Vec3 direction) {
        double x = direction.x;
        double z = direction.z;
        double y = direction.y;
        double h = Math.sqrt(x * x + z * z);
        return (float)Math.toDegrees(-Mth.atan2((double)y, (double)h));
    }

    public static double directionToYaw(Vec3 direction) {
        double x = direction.x();
        double z = direction.z();
        return Math.toDegrees(Mth.atan2((double)z, (double)x));
    }

    public static Vec3 lerpVec(float partialTicks, Vec3 vec1, Vec3 vec2) {
        double x = Mth.lerp((double)partialTicks, (double)vec1.x, (double)vec2.x);
        double y = Mth.lerp((double)partialTicks, (double)vec1.y, (double)vec2.y);
        double z = Mth.lerp((double)partialTicks, (double)vec1.z, (double)vec2.z);
        return new Vec3(x, y, z);
    }

    public static Vec3 axisOffset(Vec3 direction, Vec3 offset) {
        Vec3 forward = direction.normalize();
        Vec3 side = forward.cross(VecUtils.yAxis).normalize();
        Vec3 up = side.cross(forward).normalize();
        return forward.scale(offset.x).add(side.scale(offset.z)).add(up.scale(offset.y));
    }

    public static boolean facingSameDirection(Vec3 direction1, Vec3 direction2) {
        return direction1.dot(direction2) > 0.0;
    }

    public static int consecutiveSum(int firstNumber, int lastNumber) {
        return (lastNumber - firstNumber + 1) * (firstNumber + lastNumber) / 2;
    }

    public static float roundedStep(float n, List<Float> steps, boolean floor) {
        ArrayList<Float> sortableSteps = new ArrayList<Float>(steps);
        if (floor) {
            sortableSteps.sort(Collections.reverseOrder());
            for (Float step : sortableSteps) {
                if (!(step.floatValue() <= n)) continue;
                return step.floatValue();
            }
            return ((Float)sortableSteps.get(0)).floatValue();
        }
        Collections.sort(sortableSteps);
        for (Float step : sortableSteps) {
            if (!(step.floatValue() > n)) continue;
            return step.floatValue();
        }
        return ((Float)sortableSteps.get(sortableSteps.size() - 1)).floatValue();
    }

    public static List<Vec3> buildBlockCircle(double radius) {
        int intRadius = (int)radius;
        double radiusSq = radius * radius;
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        for (int x = -intRadius; x <= intRadius; ++x) {
            for (int z = -intRadius; z <= intRadius; ++z) {
                Vec3 pos = new Vec3((double)x, 0.0, (double)z);
                if (!(pos.lengthSqr() <= radiusSq)) continue;
                points.add(pos);
            }
        }
        return points;
    }

    public static List<BlockPos> getBlocksInLine(BlockPos startPos, BlockPos endPos) {
        int zs;
        int x1 = startPos.getX();
        int y1 = startPos.getY();
        int z1 = startPos.getZ();
        int x2 = endPos.getX();
        int y2 = endPos.getY();
        int z2 = endPos.getZ();
        ArrayList<BlockPos> points = new ArrayList<BlockPos>();
        points.add(startPos);
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int n = zs = z2 > z1 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                points.add(new BlockPos(x1, y1, z1));
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                points.add(new BlockPos(x1, y1, z1));
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                points.add(new BlockPos(x1, y1, z1));
            }
        }
        return points;
    }

    public static float ratioLerp(float time, float ratio, float maxAge, float partialTicks) {
        assert (ratio <= 1.0f);
        assert (ratio >= 0.0f);
        assert (maxAge > 0.0f);
        float currentTime = Mth.clamp((float)((time + partialTicks) / maxAge), (float)0.0f, (float)1.0f);
        return Math.max(0.0f, currentTime - ratio) / (1.0f - ratio);
    }
}

