/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.static_utilities;

import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SoundUtils {
    public static void playSound(ServerLevel level, Vec3 pos, SoundEvent soundEvent, SoundSource soundSource, float volume, double range) {
        SoundUtils.playSound(level, pos, soundEvent, soundSource, volume, range, null);
    }

    public static void playSound(ServerLevel level, Vec3 pos, SoundEvent soundEvent, SoundSource soundSource, float volume, double range, Player except) {
        SoundUtils.playSound(level, pos, soundEvent, soundSource, volume, SoundUtils.randomPitch(level.random), range, except);
    }

    public static void playSound(ServerLevel level, Vec3 pos, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, double range, Player except) {
        Holder holder = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)soundEvent.location()));
        level.getServer().getPlayerList().broadcast(except, pos.x, pos.y, pos.z, range, level.dimension(), (Packet)new ClientboundSoundPacket(holder, soundSource, pos.x, pos.y, pos.z, volume, pitch, level.random.nextLong()));
    }

    public static float randomPitch(@NotNull RandomSource random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }
}

