/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.forge.network;

import com.cerbon.cerbons_api.api.network.PacketRegistrationHandler;
import com.cerbon.cerbons_api.api.network.data.CommonPacketWrapper;
import com.cerbon.cerbons_api.api.network.data.PacketContainer;
import com.cerbon.cerbons_api.api.network.data.PacketContext;
import com.cerbon.cerbons_api.api.network.data.Side;
import com.cerbon.cerbons_api.api.network.exceptions.RegistrationException;
import com.cerbon.cerbons_api.util.Constants;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;

public class ForgeNetworkHandler
extends PacketRegistrationHandler {
    private final Map<Class<?>, Message<?>> CHANNELS = new HashMap();

    public ForgeNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        if (this.CHANNELS.get(container.classType()) == null) {
            EventNetworkChannel channel = ChannelBuilder.named((ResourceLocation)container.type().id()).optional().eventNetworkChannel().addListener(event -> {
                CommonPacketWrapper msg = (CommonPacketWrapper)container.getCodec().decode((Object)event.getPayload());
                this.buildHandler(container.handler()).accept(msg.packet(), event.getSource());
            });
            this.CHANNELS.put(container.classType(), new Message<T>(channel, container));
        }
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            EventNetworkChannel channel = message.channel();
            Connection connection = Minecraft.getInstance().getConnection().getConnection();
            if (ignoreCheck || channel.isRemotePresent(connection)) {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), Minecraft.getInstance().player.registryAccess());
                message.container.codec().encode((Object)buf, packet);
                channel.send((Object)buf, connection);
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the client, packets need to be registered on both sides!");
        }
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player, boolean ignoreCheck) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            EventNetworkChannel channel = message.channel();
            Connection connection = player.connection.getConnection();
            if (ignoreCheck || channel.isRemotePresent(connection)) {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)player.server.registryAccess());
                message.container.codec().encode((Object)buf, packet);
                channel.send((Object)buf, connection);
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the server, packets need to be registered on both sides!");
        }
    }

    private <T> BiConsumer<T, CustomPayloadEvent.Context> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            try {
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> {
                    Side side = ctx.isServerSide() ? Side.SERVER : Side.CLIENT;
                    ServerPlayer player = ctx.getSender();
                    handler.accept(new PacketContext<Object>(player, message, side));
                });
            }
            catch (Throwable t) {
                Constants.LOGGER.error("{} error handling packet", message.getClass(), (Object)t);
            }
        };
    }

    public record Message<T>(EventNetworkChannel channel, PacketContainer<T> container) {
    }
}

