/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.mixin.multipart_entities.client;

import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.OrientedBox;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin {
    @Inject(method={"extractAdditionalHitboxes(Lnet/minecraft/world/entity/Entity;Lcom/google/common/collect/ImmutableList$Builder;F)V"}, at={@At(value="TAIL")})
    private <T extends Entity> void createOrientedBoxesRenderStates(T entity, ImmutableList.Builder<HitboxRenderState> hitboxes, float partialTick, CallbackInfo ci) {
        AABB box = entity.getBoundingBox();
        if (!(box instanceof CompoundOrientedBox)) {
            return;
        }
        CompoundOrientedBox compound = (CompoundOrientedBox)box;
        for (OrientedBox orientedBox : compound) {
            Vec3 center = orientedBox.getCenter();
            Vec3 halfSize = orientedBox.getHalfExtents();
            double minX2 = center.x - halfSize.x;
            double minY2 = center.y - halfSize.y;
            double minZ2 = center.z - halfSize.z;
            double maxX2 = center.x + halfSize.x;
            double maxY2 = center.y + halfSize.y;
            double maxZ2 = center.z + halfSize.z;
            float x0 = (float)(minX2 - entity.getX());
            float y0 = (float)(minY2 - entity.getY());
            float z0 = (float)(minZ2 - entity.getZ());
            float x1 = (float)(maxX2 - entity.getX());
            float y1 = (float)(maxY2 - entity.getY());
            float z1 = (float)(maxZ2 - entity.getZ());
            hitboxes.add((Object)new HitboxRenderState((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        }
        compound.toVoxelShape().forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float x0 = (float)(minX - entity.getX());
            float y0 = (float)(minY - entity.getY());
            float z0 = (float)(minZ - entity.getZ());
            float x1 = (float)(maxX - entity.getX());
            float y1 = (float)(maxY - entity.getY());
            float z1 = (float)(maxZ - entity.getZ());
            hitboxes.add((Object)new HitboxRenderState((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f));
        });
    }
}

