/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon;

import com.ubivismedia.aidungeon.api.APIReporter;
import com.ubivismedia.aidungeon.api.EntityReportingSystem;
import com.ubivismedia.aidungeon.api.GeminiEntityExtractor;
import com.ubivismedia.aidungeon.commands.CommandHandler;
import com.ubivismedia.aidungeon.config.ConfigManager;
import com.ubivismedia.aidungeon.database.DatabaseManager;
import com.ubivismedia.aidungeon.dungeon.DungeonManager;
import com.ubivismedia.aidungeon.integration.PlaceholderAPIIntegration;
import com.ubivismedia.aidungeon.listeners.PlayerEventListener;
import com.ubivismedia.aidungeon.scheduler.DungeonScheduler;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AIDungeon
extends JavaPlugin {
    private static AIDungeon instance;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private DungeonManager dungeonManager;
    private DungeonScheduler dungeonScheduler;
    private APIReporter apiReporter;
    private EntityReportingSystem entityReportingSystem;
    private GeminiEntityExtractor geminiEntityExtractor;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.configManager = new ConfigManager(this);
        if (!this.configManager.loadConfiguration()) {
            this.getLogger().severe("Failed to load configuration! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.databaseManager = new DatabaseManager(this);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            if (!this.databaseManager.setupConnection()) {
                this.getLogger().severe("Failed to establish database connection! Plugin functionality will be limited.");
                return;
            }
            if (!this.databaseManager.createTables()) {
                this.getLogger().severe("Failed to create database tables! Plugin functionality will be limited.");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this, this::finishInitialization);
        }, 40L);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        CommandHandler commandHandler = new CommandHandler(this);
        this.getCommand("aidungeon").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("aidungeon").setTabCompleter((TabCompleter)commandHandler);
        this.dungeonManager = new DungeonManager(this);
        this.initializeReportingSystems();
        this.registerPlaceholderAPIIntegration();
        this.getLogger().info("AIDungeon plugin has been enabled!");
    }

    private void initializeReportingSystems() {
        if (this.configManager.isApiReportingEnabled()) {
            this.apiReporter = new APIReporter(this);
            this.getLogger().info("API Reporting system initialized");
            this.entityReportingSystem = new EntityReportingSystem(this);
            this.getLogger().info("Entity Reporting System initialized");
            this.geminiEntityExtractor = new GeminiEntityExtractor(this, this.entityReportingSystem);
            this.getLogger().info("Gemini Entity Extractor initialized");
        } else {
            this.getLogger().info("API Reporting is disabled in config");
        }
    }

    private void finishInitialization() {
        this.dungeonScheduler = new DungeonScheduler(this);
        this.dungeonScheduler.startSchedulers();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        this.getLogger().info("AIDungeon initialization complete!");
    }

    public void onDisable() {
        if (this.dungeonScheduler != null) {
            this.dungeonScheduler.stopSchedulers();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.databaseManager != null) {
            this.databaseManager.closeConnection();
        }
        this.getLogger().info("AIDungeon plugin has been disabled.");
    }

    public static AIDungeon getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public DungeonManager getDungeonManager() {
        return this.dungeonManager;
    }

    public DungeonScheduler getDungeonScheduler() {
        return this.dungeonScheduler;
    }

    public APIReporter getApiReporter() {
        return this.apiReporter;
    }

    public EntityReportingSystem getEntityReportingSystem() {
        return this.entityReportingSystem;
    }

    public GeminiEntityExtractor getGeminiEntityExtractor() {
        return this.geminiEntityExtractor;
    }

    public void log(Level level, String message) {
        this.getLogger().log(level, message);
    }

    private void registerPlaceholderAPIIntegration() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.getLogger().info("PlaceholderAPI detected, registering expansion...");
            new PlaceholderAPIIntegration(this).register();
            this.getLogger().info("Successfully registered PlaceholderAPI expansion");
        } else {
            this.getLogger().info("PlaceholderAPI not detected, skipping placeholder registration");
        }
    }
}

