/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.api;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.config.ConfigManager;
import com.ubivismedia.aidungeon.database.DatabaseManager;
import com.ubivismedia.aidungeon.lib.gson.Gson;
import com.ubivismedia.aidungeon.lib.gson.GsonBuilder;
import com.ubivismedia.aidungeon.lib.slf4j.Logger;
import com.ubivismedia.aidungeon.lib.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class EntityReportingSystem {
    private static final Logger log = LoggerFactory.getLogger(EntityReportingSystem.class);
    private static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS reported_entities (id VARCHAR(36) PRIMARY KEY, entity_type VARCHAR(50) NOT NULL, entity_name VARCHAR(100) NOT NULL, entity_data TEXT NOT NULL, dungeon_theme VARCHAR(50), biome VARCHAR(50), reported_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, response_code INT, plugin_version VARCHAR(20), UNIQUE(entity_type, entity_name))";
    private final AIDungeon plugin;
    private final DatabaseManager databaseManager;
    private final ConfigManager configManager;
    private final Gson gson;
    private final String reportEndpoint;
    private final String pluginVersion;
    private final Set<String> reportQueue;
    private final boolean enableReporting;

    public EntityReportingSystem(AIDungeon plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.configManager = plugin.getConfigManager();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.reportEndpoint = this.configManager.getString("reporting.endpoint", "https://api.ubivismedia.com/aidungeon/entities");
        this.pluginVersion = plugin.getDescription().getVersion();
        this.reportQueue = new HashSet<String>();
        this.enableReporting = this.configManager.getBoolean("reporting.enabled", true);
        this.initDatabase();
    }

    private void initDatabase() {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(CREATE_TABLE_SQL);){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            log.error("Failed to initialize entity reporting database table", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueEntityReport(String entityType, String entityName, String entityData, String dungeonTheme, String biome) {
        if (!this.enableReporting) {
            return false;
        }
        String entityKey = entityType + ":" + entityName;
        if (this.isAlreadyReported(entityType, entityName)) {
            log.debug("Entity {} already reported, skipping", (Object)entityKey);
            return false;
        }
        Set<String> set = this.reportQueue;
        synchronized (set) {
            this.reportQueue.add(entityKey);
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.processEntityReport(entityType, entityName, entityData, dungeonTheme, biome);
            }
            catch (Exception e) {
                log.error("Failed to process entity report for {}", (Object)entityKey, (Object)e);
            }
            finally {
                Set<String> set = this.reportQueue;
                synchronized (set) {
                    this.reportQueue.remove(entityKey);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean isAlreadyReported(String entityType, String entityName) {
        String sql = "SELECT COUNT(*) FROM reported_entities WHERE entity_type = ? AND entity_name = ?";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, entityType);
            stmt.setString(2, entityName);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next() && rs.getInt(1) > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            log.error("Error checking if entity was already reported", e);
        }
        Set<String> set = this.reportQueue;
        synchronized (set) {
            return this.reportQueue.contains(entityType + ":" + entityName);
        }
    }

    private void processEntityReport(String entityType, String entityName, String entityData, String dungeonTheme, String biome) {
        String reportId = UUID.randomUUID().toString();
        EntityReport report = new EntityReport(reportId, entityType, entityName, entityData, dungeonTheme, biome, this.plugin.getDescription().getVersion());
        String jsonPayload = this.gson.toJson(report);
        try {
            int responseCode = this.sendReport(jsonPayload);
            this.recordReport(report, responseCode);
            if (responseCode == 200) {
                log.info("Successfully reported new entity: {} - {}", (Object)entityType, (Object)entityName);
            } else if (responseCode == 409) {
                log.info("Entity already exists in central database: {} - {}", (Object)entityType, (Object)entityName);
            } else {
                log.warn("Unexpected response code {} when reporting entity: {} - {}", responseCode, entityType, entityName);
            }
        }
        catch (IOException e) {
            log.error("Failed to send entity report", e);
            this.recordReport(report, -1);
        }
    }

    private int sendReport(String jsonPayload) throws IOException {
        URL url = new URL(this.reportEndpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "AIDungeon/" + this.pluginVersion);
        connection.setDoOutput(true);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        return connection.getResponseCode();
    }

    private void recordReport(EntityReport report, int responseCode) {
        String sql = "INSERT INTO reported_entities (id, entity_type, entity_name, entity_data, dungeon_theme, biome, response_code, plugin_version) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(entity_type, entity_name) DO UPDATE SET response_code = ?, plugin_version = ?";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, report.getId());
            stmt.setString(2, report.getEntityType());
            stmt.setString(3, report.getEntityName());
            stmt.setString(4, report.getEntityData());
            stmt.setString(5, report.getDungeonTheme());
            stmt.setString(6, report.getBiome());
            stmt.setInt(7, responseCode);
            stmt.setString(8, report.getPluginVersion());
            stmt.setInt(9, responseCode);
            stmt.setString(10, report.getPluginVersion());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            log.error("Failed to record entity report in database", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean markEntityImplemented(String entityType, String entityName, String version) {
        String implementedVersion = version != null ? version : this.pluginVersion;
        String sql = "UPDATE reported_entities SET plugin_version = ? WHERE entity_type = ? AND entity_name = ?";
        try (Connection conn = this.databaseManager.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, implementedVersion);
                    stmt.setString(2, entityType);
                    stmt.setString(3, entityName);
                    int updated = stmt.executeUpdate();
                    boolean bl2 = bl = updated > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            log.error("Failed to mark entity as implemented", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public EntityReport[] getUnimplementedEntities() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class EntityReport {
        private String id;
        private String entityType;
        private String entityName;
        private String entityData;
        private String dungeonTheme;
        private String biome;
        private String pluginVersion;

        public String getId() {
            return this.id;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getEntityData() {
            return this.entityData;
        }

        public String getDungeonTheme() {
            return this.dungeonTheme;
        }

        public String getBiome() {
            return this.biome;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setEntityData(String entityData) {
            this.entityData = entityData;
        }

        public void setDungeonTheme(String dungeonTheme) {
            this.dungeonTheme = dungeonTheme;
        }

        public void setBiome(String biome) {
            this.biome = biome;
        }

        public void setPluginVersion(String pluginVersion) {
            this.pluginVersion = pluginVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityReport)) {
                return false;
            }
            EntityReport other = (EntityReport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$entityType = this.getEntityType();
            String other$entityType = other.getEntityType();
            if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
                return false;
            }
            String this$entityName = this.getEntityName();
            String other$entityName = other.getEntityName();
            if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
                return false;
            }
            String this$entityData = this.getEntityData();
            String other$entityData = other.getEntityData();
            if (this$entityData == null ? other$entityData != null : !this$entityData.equals(other$entityData)) {
                return false;
            }
            String this$dungeonTheme = this.getDungeonTheme();
            String other$dungeonTheme = other.getDungeonTheme();
            if (this$dungeonTheme == null ? other$dungeonTheme != null : !this$dungeonTheme.equals(other$dungeonTheme)) {
                return false;
            }
            String this$biome = this.getBiome();
            String other$biome = other.getBiome();
            if (this$biome == null ? other$biome != null : !this$biome.equals(other$biome)) {
                return false;
            }
            String this$pluginVersion = this.getPluginVersion();
            String other$pluginVersion = other.getPluginVersion();
            return !(this$pluginVersion == null ? other$pluginVersion != null : !this$pluginVersion.equals(other$pluginVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntityReport;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $entityType = this.getEntityType();
            result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
            String $entityName = this.getEntityName();
            result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
            String $entityData = this.getEntityData();
            result = result * 59 + ($entityData == null ? 43 : $entityData.hashCode());
            String $dungeonTheme = this.getDungeonTheme();
            result = result * 59 + ($dungeonTheme == null ? 43 : $dungeonTheme.hashCode());
            String $biome = this.getBiome();
            result = result * 59 + ($biome == null ? 43 : $biome.hashCode());
            String $pluginVersion = this.getPluginVersion();
            result = result * 59 + ($pluginVersion == null ? 43 : $pluginVersion.hashCode());
            return result;
        }

        public String toString() {
            return "EntityReportingSystem.EntityReport(id=" + this.getId() + ", entityType=" + this.getEntityType() + ", entityName=" + this.getEntityName() + ", entityData=" + this.getEntityData() + ", dungeonTheme=" + this.getDungeonTheme() + ", biome=" + this.getBiome() + ", pluginVersion=" + this.getPluginVersion() + ")";
        }

        public EntityReport() {
        }

        public EntityReport(String id, String entityType, String entityName, String entityData, String dungeonTheme, String biome, String pluginVersion) {
            this.id = id;
            this.entityType = entityType;
            this.entityName = entityName;
            this.entityData = entityData;
            this.dungeonTheme = dungeonTheme;
            this.biome = biome;
            this.pluginVersion = pluginVersion;
        }
    }
}

