/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.api;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.api.EntityReportingSystem;
import com.ubivismedia.aidungeon.lib.gson.Gson;
import com.ubivismedia.aidungeon.lib.gson.JsonArray;
import com.ubivismedia.aidungeon.lib.gson.JsonElement;
import com.ubivismedia.aidungeon.lib.gson.JsonObject;
import com.ubivismedia.aidungeon.lib.gson.JsonParser;
import com.ubivismedia.aidungeon.lib.slf4j.Logger;
import com.ubivismedia.aidungeon.lib.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeminiEntityExtractor {
    private static final Logger log = LoggerFactory.getLogger(GeminiEntityExtractor.class);
    private final AIDungeon plugin;
    private final EntityReportingSystem reportingSystem;
    private final Gson gson;
    private static final String[] ENTITY_TYPES = new String[]{"MOB", "POTION_EFFECT", "ITEM", "BLOCK", "STRUCTURE", "BOSS"};

    public GeminiEntityExtractor(AIDungeon plugin, EntityReportingSystem reportingSystem) {
        this.plugin = plugin;
        this.reportingSystem = reportingSystem;
        this.gson = new Gson();
    }

    public List<ExtractedEntity> extractEntities(String geminiResponse, String dungeonTheme, String biome) {
        ArrayList<ExtractedEntity> extractedEntities = new ArrayList<ExtractedEntity>();
        try {
            JsonElement jsonElement = JsonParser.parseString(geminiResponse);
            if (jsonElement.isJsonObject()) {
                this.extractEntitiesFromStructuredResponse(jsonElement.getAsJsonObject(), dungeonTheme, biome, extractedEntities);
            } else if (geminiResponse.contains("entity") || geminiResponse.contains("mob") || geminiResponse.contains("potion") || geminiResponse.contains("effect") || geminiResponse.contains("item") || geminiResponse.contains("boss")) {
                this.extractEntitiesFromTextResponse(geminiResponse, dungeonTheme, biome, extractedEntities);
            }
        }
        catch (Exception e) {
            log.error("Failed to extract entities from Gemini response", e);
        }
        return extractedEntities;
    }

    private void extractEntitiesFromStructuredResponse(JsonObject jsonObject, String dungeonTheme, String biome, List<ExtractedEntity> extractedEntities) {
        for (String entityType : ENTITY_TYPES) {
            String entityTypeKey = entityType.toLowerCase();
            String entitiesKey = entityTypeKey + "s";
            for (String possibleKey : new String[]{entityTypeKey, entitiesKey, "custom_" + entityTypeKey, "custom_" + entitiesKey, entityType, entityType + "s"}) {
                if (!jsonObject.has(possibleKey)) continue;
                JsonElement element = jsonObject.get(possibleKey);
                if (element.isJsonArray()) {
                    JsonArray entities = element.getAsJsonArray();
                    for (JsonElement entityElement : entities) {
                        this.processEntityElement(entityElement, entityType, dungeonTheme, biome, extractedEntities);
                    }
                    continue;
                }
                if (!element.isJsonObject()) continue;
                this.processEntityElement(element, entityType, dungeonTheme, biome, extractedEntities);
            }
        }
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                this.extractEntitiesFromStructuredResponse(((JsonElement)entry.getValue()).getAsJsonObject(), dungeonTheme, biome, extractedEntities);
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement element : array) {
                if (!element.isJsonObject()) continue;
                this.extractEntitiesFromStructuredResponse(element.getAsJsonObject(), dungeonTheme, biome, extractedEntities);
            }
        }
    }

    private void processEntityElement(JsonElement entityElement, String entityType, String dungeonTheme, String biome, List<ExtractedEntity> extractedEntities) {
        if (!entityElement.isJsonObject()) {
            return;
        }
        JsonObject entityObject = entityElement.getAsJsonObject();
        String entityName = null;
        for (String nameField : new String[]{"name", "id", "identifier", "type", "key"}) {
            if (!entityObject.has(nameField) || !entityObject.get(nameField).isJsonPrimitive()) continue;
            entityName = entityObject.get(nameField).getAsString();
            break;
        }
        if (entityName == null || entityName.isEmpty()) {
            return;
        }
        String entityData = this.gson.toJson(entityObject);
        boolean reported = this.reportingSystem.queueEntityReport(entityType, entityName, entityData, dungeonTheme, biome);
        if (reported) {
            extractedEntities.add(new ExtractedEntity(entityType, entityName, entityData));
        }
    }

    private void extractEntitiesFromTextResponse(String response, String dungeonTheme, String biome, List<ExtractedEntity> extractedEntities) {
        HashMap potentialEntities = new HashMap();
        for (String entityType : ENTITY_TYPES) {
            potentialEntities.put(entityType, new HashMap());
        }
        for (String line : response.split("\\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            for (String entityType : ENTITY_TYPES) {
                String entityName;
                String lowerEntityType = entityType.toLowerCase();
                if (!line.toLowerCase().contains(lowerEntityType) && !line.toLowerCase().contains(lowerEntityType + "s") || (entityName = this.extractEntityName(line, lowerEntityType)) == null || entityName.isEmpty()) continue;
                JsonObject entityData = new JsonObject();
                entityData.addProperty("name", entityName);
                entityData.addProperty("description", line);
                entityData.addProperty("source", "text_extraction");
                boolean reported = this.reportingSystem.queueEntityReport(entityType, entityName, entityData.toString(), dungeonTheme, biome);
                if (!reported) continue;
                extractedEntities.add(new ExtractedEntity(entityType, entityName, entityData.toString()));
            }
        }
    }

    private String extractEntityName(String line, String entityTypeHint) {
        int quoteStart = line.indexOf(34);
        int quoteEnd = line.indexOf(34, quoteStart + 1);
        if (quoteStart >= 0 && quoteEnd > quoteStart) {
            return line.substring(quoteStart + 1, quoteEnd).trim();
        }
        int nameIndex = line.toLowerCase().indexOf("name:");
        if (nameIndex >= 0) {
            String afterName = line.substring(nameIndex + 5).trim();
            int endOfName = afterName.indexOf(44);
            if (endOfName < 0) {
                endOfName = afterName.indexOf(46);
            }
            if (endOfName < 0) {
                endOfName = afterName.indexOf(58);
            }
            if (endOfName < 0) {
                endOfName = afterName.length();
            }
            return afterName.substring(0, endOfName).trim();
        }
        int typeIndex = line.toLowerCase().indexOf(entityTypeHint + ":");
        if (typeIndex >= 0) {
            String afterType = line.substring(typeIndex + entityTypeHint.length() + 1).trim();
            int endOfName = afterType.indexOf(44);
            if (endOfName < 0) {
                endOfName = afterType.indexOf(46);
            }
            if (endOfName < 0) {
                endOfName = afterType.indexOf(58);
            }
            if (endOfName < 0) {
                endOfName = afterType.length();
            }
            return afterType.substring(0, endOfName).trim();
        }
        int dashIndex = line.indexOf("- ");
        if (dashIndex >= 0) {
            int endOfName;
            String afterDash = line.substring(dashIndex + 2).trim();
            if (afterDash.toLowerCase().startsWith(entityTypeHint + ":")) {
                afterDash = afterDash.substring(entityTypeHint.length() + 1).trim();
            }
            if ((endOfName = afterDash.indexOf(58)) < 0) {
                endOfName = afterDash.indexOf(44);
            }
            if (endOfName < 0) {
                endOfName = afterDash.indexOf(46);
            }
            if (endOfName < 0) {
                endOfName = afterDash.length();
            }
            return afterDash.substring(0, endOfName).trim();
        }
        String[] words = line.split("\\s+");
        for (int i = 1; i < words.length; ++i) {
            String word = words[i];
            if (word.isEmpty() || !Character.isUpperCase(word.charAt(0))) continue;
            return word.replaceAll("[^a-zA-Z0-9]", "");
        }
        return null;
    }

    public static class ExtractedEntity {
        private final String type;
        private final String name;
        private final String data;

        public ExtractedEntity(String type, String name, String data) {
            this.type = type;
            this.name = name;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return this.type + ":" + this.name;
        }
    }
}

