/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.api;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.config.ConfigManager;
import com.ubivismedia.aidungeon.lib.gson.Gson;
import com.ubivismedia.aidungeon.lib.gson.GsonBuilder;
import com.ubivismedia.aidungeon.lib.gson.JsonArray;
import com.ubivismedia.aidungeon.lib.gson.JsonElement;
import com.ubivismedia.aidungeon.lib.gson.JsonObject;
import com.ubivismedia.aidungeon.lib.gson.JsonParser;
import com.ubivismedia.aidungeon.lib.gson.JsonSyntaxException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LightweightGeminiClient {
    private final AIDungeon plugin;
    private final String apiKey;
    private final String model;
    private final int timeout;
    private final HttpClient httpClient;
    private final Gson gson;
    private static final String GEMINI_API_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta/models/%s:generateContent?key=%s";
    private static final Pattern JSON_PATTERN = Pattern.compile("\\{.*\\}", 32);

    public LightweightGeminiClient(AIDungeon plugin, String apiKey, String model, int timeout) {
        this.plugin = plugin;
        this.apiKey = apiKey;
        this.model = model;
        this.timeout = timeout;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(15L)).build();
        this.gson = new GsonBuilder().setLenient().create();
    }

    public CompletableFuture<String> generateContent(String prompt) {
        String language;
        CompletableFuture<String> future = new CompletableFuture<String>();
        String currentModel = this.model;
        ConfigManager configManager = this.plugin.getConfigManager();
        if (configManager != null && configManager.getGeminiPeakHoursModel() != null && configManager.getGeminiOffPeakModel() != null) {
            currentModel = configManager.getCurrentGeminiModel();
            if (configManager.getConfig().getBoolean("debug.logApiCalls", false)) {
                this.plugin.getLogger().info("Using Gemini-Model: " + currentModel + (configManager.isWithinPeakHours() ? " (Peak hours)" : " (Off-peak hours)"));
            }
        }
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            future.completeExceptionally(new RuntimeException("No Gemini API key provided"));
            return future;
        }
        String apiUrl = String.format(GEMINI_API_ENDPOINT, currentModel, this.apiKey);
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject content = new JsonObject();
        JsonArray parts = new JsonArray();
        JsonObject part = new JsonObject();
        part.addProperty("text", prompt);
        parts.add(part);
        content.add("parts", parts);
        contents.add(content);
        requestBody.add("contents", contents);
        JsonObject generationConfig = new JsonObject();
        generationConfig.addProperty("temperature", 0.7);
        generationConfig.addProperty("maxOutputTokens", configManager != null ? configManager.getConfig().getInt("gemini.maxTokens", 2048) : 2048);
        requestBody.add("generationConfig", generationConfig);
        if (configManager != null && (language = configManager.getGeminiLanguage()) != null && !language.isEmpty()) {
            JsonObject systemInstruction = new JsonObject();
            String languageInstruction = "Please respond in " + language + " language.";
            systemInstruction.addProperty("text", languageInstruction);
            requestBody.add("systemInstruction", systemInstruction);
            if (configManager.getConfig().getBoolean("debug.logApiCalls", false)) {
                this.plugin.getLogger().info("Setze Gemini-Sprache auf: " + language);
            }
        }
        String requestBodyJson = this.gson.toJson(requestBody);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(this.timeout)).POST(HttpRequest.BodyPublishers.ofString(requestBodyJson)).build();
        this.plugin.getLogger().info("Sending request to Gemini API...");
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            int statusCode = response.statusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Gemini API-request failed with Statuscode: " + statusCode + ", Antwort: " + (String)response.body());
            }
            return (String)response.body();
        })).thenApply(this::extractTextFromResponse)).thenApply(this::cleanAndEnsureValidJson)).thenAccept(future::complete)).exceptionally(e -> {
            this.plugin.getLogger().log(Level.SEVERE, "Error calling Gemini API: ", (Throwable)e);
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    private String extractTextFromResponse(String response) {
        try {
            JsonObject content;
            JsonObject candidate;
            JsonArray candidates;
            JsonObject jsonResponse = this.gson.fromJson(response, JsonObject.class);
            StringBuilder extractedText = new StringBuilder();
            if (jsonResponse.has("candidates") && (candidates = jsonResponse.getAsJsonArray("candidates")).size() > 0 && (candidate = candidates.get(0).getAsJsonObject()).has("content") && (content = candidate.getAsJsonObject("content")).has("parts")) {
                JsonArray parts = content.getAsJsonArray("parts");
                for (int i = 0; i < parts.size(); ++i) {
                    JsonObject part = parts.get(i).getAsJsonObject();
                    if (!part.has("text")) continue;
                    extractedText.append(part.get("text").getAsString());
                }
            }
            if (extractedText.length() == 0) {
                throw new RuntimeException("Could not extract text from Gemini API response: " + response);
            }
            return extractedText.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error parsing Gemini API response: ", e);
            throw new RuntimeException("Could not parse Gemini API response", e);
        }
    }

    private String cleanAndEnsureValidJson(String text) {
        Matcher jsonMatcher;
        if (this.plugin.getConfigManager().getConfig().getBoolean("debug.logApiCalls", false)) {
            this.plugin.getLogger().info("Extract text of Gemini API: " + text);
        }
        if ((jsonMatcher = JSON_PATTERN.matcher(text)).find()) {
            String jsonCandidate = jsonMatcher.group(0);
            try {
                JsonElement element = JsonParser.parseString(jsonCandidate);
                if (element.isJsonObject()) {
                    return jsonCandidate;
                }
            }
            catch (JsonSyntaxException e) {
                this.plugin.getLogger().warning("Found JSON-like content, but it's not valid: " + e.getMessage());
            }
        }
        try {
            JsonParser.parseString(text);
            return text;
        }
        catch (JsonSyntaxException e) {
            this.plugin.getLogger().warning("Received non-JSON response from Gemini API: " + e.getMessage());
            return this.createFallbackJson();
        }
    }

    private String createFallbackJson() {
        JsonObject fallback = new JsonObject();
        JsonArray rooms = new JsonArray();
        JsonObject entranceRoom = new JsonObject();
        entranceRoom.addProperty("roomType", "ENTRANCE");
        entranceRoom.addProperty("width", 7);
        entranceRoom.addProperty("height", 4);
        entranceRoom.addProperty("length", 7);
        JsonObject entrancePos = new JsonObject();
        entrancePos.addProperty("x", 0);
        entrancePos.addProperty("y", 0);
        entrancePos.addProperty("z", 0);
        entranceRoom.add("relativePosition", entrancePos);
        rooms.add(entranceRoom);
        JsonObject corridorRoom = new JsonObject();
        corridorRoom.addProperty("roomType", "CORRIDOR");
        corridorRoom.addProperty("width", 3);
        corridorRoom.addProperty("height", 3);
        corridorRoom.addProperty("length", 8);
        JsonObject corridorPos = new JsonObject();
        corridorPos.addProperty("x", 2);
        corridorPos.addProperty("y", 0);
        corridorPos.addProperty("z", 7);
        corridorRoom.add("relativePosition", corridorPos);
        rooms.add(corridorRoom);
        JsonObject bossRoom = new JsonObject();
        bossRoom.addProperty("roomType", "BOSS");
        bossRoom.addProperty("width", 10);
        bossRoom.addProperty("height", 5);
        bossRoom.addProperty("length", 10);
        JsonObject bossPos = new JsonObject();
        bossPos.addProperty("x", -2);
        bossPos.addProperty("y", 0);
        bossPos.addProperty("z", 15);
        bossRoom.add("relativePosition", bossPos);
        rooms.add(bossRoom);
        JsonObject boss = new JsonObject();
        boss.addProperty("name", "Dungeon Guardian");
        boss.addProperty("baseEntity", "ZOMBIE");
        boss.addProperty("health", 100);
        fallback.add("rooms", rooms);
        fallback.add("boss", boss);
        fallback.addProperty("description", "A simple dungeon with an entrance, corridor, and boss room.");
        return this.gson.toJson(fallback);
    }
}

