/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.commands;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.dungeon.DungeonManager;
import com.ubivismedia.aidungeon.model.Dungeon;
import com.ubivismedia.aidungeon.model.Room;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final AIDungeon plugin;

    public CommandHandler(AIDungeon plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "list": {
                this.listDungeons(sender);
                break;
            }
            case "info": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /aidungeon info <dungeonId>");
                    return true;
                }
                this.showDungeonInfo(sender, args[1]);
                break;
            }
            case "teleport": 
            case "tp": {
                if (!sender.hasPermission("aidungeon.teleport")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /aidungeon teleport <dungeonId>");
                    return true;
                }
                this.teleportToDungeon((Player)sender, args[1]);
                break;
            }
            case "collapse": {
                if (!sender.hasPermission("aidungeon.forcecollapse")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /aidungeon collapse <dungeonId>");
                    return true;
                }
                this.forceDungeonCollapse(sender, args[1]);
                break;
            }
            case "scan": {
                if (!sender.hasPermission("aidungeon.forcescan")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.forceScan(sender);
                break;
            }
            case "pending": {
                if (!sender.hasPermission("aidungeon.admin")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.listPendingLocations(sender);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Type /aidungeon help for a list of commands.");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>(Arrays.asList("help", "list", "info"));
            if (sender.hasPermission("aidungeon.teleport")) {
                subCommands.add("teleport");
                subCommands.add("tp");
            }
            if (sender.hasPermission("aidungeon.forcecollapse")) {
                subCommands.add("collapse");
            }
            if (sender.hasPermission("aidungeon.forcescan")) {
                subCommands.add("scan");
            }
            if (sender.hasPermission("aidungeon.admin")) {
                subCommands.add("pending");
            }
            return subCommands.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("teleport") || args[0].equalsIgnoreCase("tp") || args[0].equalsIgnoreCase("collapse"))) {
            DungeonManager dungeonManager = this.plugin.getDungeonManager();
            if (dungeonManager == null) {
                return Collections.emptyList();
            }
            return dungeonManager.getActiveDungeons().keySet().stream().map(String::valueOf).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        return null;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "===== AIDungeon Commands =====");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon help" + String.valueOf(ChatColor.WHITE) + " - Show this help message");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon list" + String.valueOf(ChatColor.WHITE) + " - List all discovered dungeons");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon info <dungeonId>" + String.valueOf(ChatColor.WHITE) + " - Show information about a specific dungeon");
        if (sender.hasPermission("aidungeon.teleport")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon teleport <dungeonId>" + String.valueOf(ChatColor.WHITE) + " - Teleport to a dungeon entrance");
        }
        if (sender.hasPermission("aidungeon.forcecollapse")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon collapse <dungeonId>" + String.valueOf(ChatColor.WHITE) + " - Force a dungeon to collapse");
        }
        if (sender.hasPermission("aidungeon.forcescan")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon scan" + String.valueOf(ChatColor.WHITE) + " - Force a world scan for dungeons");
        }
        if (sender.hasPermission("aidungeon.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/aidungeon pending" + String.valueOf(ChatColor.WHITE) + " - List pending dungeon generation locations");
        }
    }

    private void listDungeons(CommandSender sender) {
        DungeonManager dungeonManager = this.plugin.getDungeonManager();
        if (dungeonManager == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon manager is not initialized yet. Please try again in a few moments.");
            return;
        }
        Map<Integer, Dungeon> activeDungeons = dungeonManager.getActiveDungeons();
        if (activeDungeons.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No dungeons have been discovered yet.");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "===== Discovered Dungeons =====");
        for (Map.Entry<Integer, Dungeon> entry : activeDungeons.entrySet()) {
            Dungeon dungeon = entry.getValue();
            String status = switch (dungeon.getStatus()) {
                default -> throw new MatchException(null, null);
                case Dungeon.Status.GENERATING -> String.valueOf(ChatColor.GRAY) + "Generating";
                case Dungeon.Status.ACTIVE -> String.valueOf(ChatColor.GREEN) + "Active";
                case Dungeon.Status.EXPLORED -> String.valueOf(ChatColor.BLUE) + "Explored";
                case Dungeon.Status.COLLAPSING -> String.valueOf(ChatColor.RED) + "Collapsing";
                case Dungeon.Status.COLLAPSED -> String.valueOf(ChatColor.DARK_RED) + "Collapsed";
            };
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "ID: " + String.valueOf(ChatColor.WHITE) + dungeon.getId() + " | " + String.valueOf(ChatColor.YELLOW) + "Theme: " + String.valueOf(ChatColor.WHITE) + this.formatThemeName(dungeon.getTheme()) + " | " + String.valueOf(ChatColor.YELLOW) + "Status: " + status + " | " + String.valueOf(ChatColor.YELLOW) + "Location: " + String.valueOf(ChatColor.WHITE) + dungeon.getXCoord() + ", " + dungeon.getYCoord() + ", " + dungeon.getZCoord() + " in " + dungeon.getWorldName());
        }
    }

    private String formatThemeName(String theme) {
        String[] words = theme.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }

    private void showDungeonInfo(CommandSender sender, String dungeonIdStr) {
        Dungeon dungeon;
        int dungeonId;
        block51: {
            try {
                dungeonId = Integer.parseInt(dungeonIdStr);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid dungeon ID. Must be a number.");
                return;
            }
            DungeonManager dungeonManager = this.plugin.getDungeonManager();
            if (dungeonManager == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon manager is not initialized yet. Please try again in a few moments.");
                return;
            }
            dungeon = dungeonManager.getDungeon(dungeonId);
            if (dungeon == null) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Looking up dungeon in database...");
                try (Connection conn = this.plugin.getDatabaseManager().getConnection();
                     PreparedStatement stmt = conn.prepareStatement("SELECT * FROM dungeons WHERE id = ?");){
                    stmt.setInt(1, dungeonId);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        dungeon = new Dungeon();
                        dungeon.setId(rs.getInt("id"));
                        dungeon.setWorldName(rs.getString("world_name"));
                        dungeon.setBiomeType(rs.getString("biome_type"));
                        dungeon.setTheme(rs.getString("theme"));
                        dungeon.setXCoord(rs.getInt("x_coord"));
                        dungeon.setYCoord(rs.getInt("y_coord"));
                        dungeon.setZCoord(rs.getInt("z_coord"));
                        dungeon.setCreatedAt(rs.getTimestamp("created_at").toLocalDateTime());
                        dungeon.setStatus(Dungeon.Status.valueOf(rs.getString("status")));
                        dungeon.setBossDefeated(rs.getBoolean("boss_defeated"));
                        try (PreparedStatement roomStmt = conn.prepareStatement("SELECT * FROM rooms WHERE dungeon_id = ?");){
                            roomStmt.setInt(1, dungeonId);
                            ResultSet resultSet = roomStmt.executeQuery();
                            ArrayList<Room> rooms = new ArrayList<Room>();
                            while (resultSet.next()) {
                                Room room = new Room();
                                room.setId(resultSet.getInt("id"));
                                room.setDungeonId(resultSet.getInt("dungeon_id"));
                                room.setRoomType(resultSet.getString("room_type"));
                                room.setXCoord(resultSet.getInt("x_coord"));
                                room.setYCoord(resultSet.getInt("y_coord"));
                                room.setZCoord(resultSet.getInt("z_coord"));
                                room.setWidth(resultSet.getInt("width"));
                                room.setHeight(resultSet.getInt("height"));
                                room.setLength(resultSet.getInt("length"));
                                room.setExplorationStatus(Room.ExplorationStatus.valueOf(resultSet.getString("exploration_status")));
                                rooms.add(room);
                            }
                            dungeon.setRooms(rooms);
                            break block51;
                        }
                    }
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon with ID " + dungeonId + " not found.");
                    return;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error fetching dungeon info: ", e);
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Error fetching dungeon information from database.");
                    return;
                }
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "===== Dungeon #" + dungeon.getId() + " =====");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Theme: " + String.valueOf(ChatColor.WHITE) + this.formatThemeName(dungeon.getTheme()));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Biome: " + String.valueOf(ChatColor.WHITE) + dungeon.getBiomeType());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Location: " + String.valueOf(ChatColor.WHITE) + dungeon.getXCoord() + ", " + dungeon.getYCoord() + ", " + dungeon.getZCoord() + " in " + dungeon.getWorldName());
        String status = switch (dungeon.getStatus()) {
            default -> throw new MatchException(null, null);
            case Dungeon.Status.GENERATING -> String.valueOf(ChatColor.GRAY) + "Generating";
            case Dungeon.Status.ACTIVE -> String.valueOf(ChatColor.GREEN) + "Active";
            case Dungeon.Status.EXPLORED -> String.valueOf(ChatColor.BLUE) + "Explored";
            case Dungeon.Status.COLLAPSING -> String.valueOf(ChatColor.RED) + "Collapsing";
            case Dungeon.Status.COLLAPSED -> String.valueOf(ChatColor.DARK_RED) + "Collapsed";
        };
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Status: " + status);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Boss Defeated: " + String.valueOf(ChatColor.WHITE) + (dungeon.isBossDefeated() ? "Yes" : "No"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Created: " + String.valueOf(ChatColor.WHITE) + dungeon.getCreatedAt().format(formatter));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Rooms: " + String.valueOf(ChatColor.WHITE) + dungeon.getRooms().size());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Exploration: " + String.valueOf(ChatColor.WHITE) + String.format("%.1f%%", dungeon.getExplorationPercentage()));
        Map<String, Long> roomTypes = dungeon.getRooms().stream().collect(Collectors.groupingBy(Room::getRoomType, Collectors.counting()));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Room Types: ");
        for (Map.Entry entry : roomTypes.entrySet()) {
            sender.sendMessage("  " + String.valueOf(ChatColor.WHITE) + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            try (Connection connection = this.plugin.getDatabaseManager().getConnection();
                 PreparedStatement stmt = connection.prepareStatement("SELECT * FROM player_progress WHERE player_uuid = ? AND dungeon_id = ?");){
                stmt.setString(1, player.getUniqueId().toString());
                stmt.setInt(2, dungeonId);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    double explorationPercent = rs.getDouble("exploration_percent");
                    String lastVisit = rs.getTimestamp("last_visit").toLocalDateTime().format(formatter);
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Your progress: ");
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Exploration: " + String.valueOf(ChatColor.WHITE) + String.format("%.1f%%", explorationPercent));
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last Visit: " + String.valueOf(ChatColor.WHITE) + lastVisit);
                }
            }
            catch (SQLException sQLException) {
                this.plugin.getLogger().log(Level.SEVERE, "Error fetching player progress: ", sQLException);
            }
        }
    }

    private void teleportToDungeon(Player player, String dungeonIdStr) {
        int dungeonId;
        try {
            dungeonId = Integer.parseInt(dungeonIdStr);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid dungeon ID. Must be a number.");
            return;
        }
        DungeonManager dungeonManager = this.plugin.getDungeonManager();
        if (dungeonManager == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon manager is not initialized yet. Please try again in a few moments.");
            return;
        }
        Dungeon dungeon = dungeonManager.getDungeon(dungeonId);
        if (dungeon == null) {
            try (Connection conn = this.plugin.getDatabaseManager().getConnection();
                 PreparedStatement stmt = conn.prepareStatement("SELECT * FROM dungeons WHERE id = ?");){
                stmt.setInt(1, dungeonId);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    String worldName = rs.getString("world_name");
                    int x = rs.getInt("x_coord");
                    int y = rs.getInt("y_coord");
                    int z = rs.getInt("z_coord");
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "World '" + worldName + "' does not exist or is not loaded.");
                        return;
                    }
                    Location entranceLocation = new Location(world, (double)x, (double)y, (double)z);
                    player.teleport(entranceLocation);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to dungeon #" + dungeonId + " entrance.");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon with ID " + dungeonId + " not found.");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error teleporting to dungeon: ", e);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error teleporting to dungeon.");
            }
        } else {
            World world = Bukkit.getWorld((String)dungeon.getWorldName());
            if (world == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "World '" + dungeon.getWorldName() + "' does not exist or is not loaded.");
                return;
            }
            Location entranceLocation = dungeon.getEntranceLocation(world);
            player.teleport(entranceLocation);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to dungeon #" + dungeonId + " entrance.");
        }
    }

    private void forceDungeonCollapse(CommandSender sender, String dungeonIdStr) {
        int dungeonId;
        try {
            dungeonId = Integer.parseInt(dungeonIdStr);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid dungeon ID. Must be a number.");
            return;
        }
        DungeonManager dungeonManager = this.plugin.getDungeonManager();
        if (dungeonManager == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon manager is not initialized yet. Please try again in a few moments.");
            return;
        }
        Dungeon dungeon = dungeonManager.getDungeon(dungeonId);
        if (dungeon == null) {
            try (Connection conn = this.plugin.getDatabaseManager().getConnection();
                 PreparedStatement stmt = conn.prepareStatement("SELECT * FROM dungeons WHERE id = ?");){
                stmt.setInt(1, dungeonId);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Dungeon with ID " + dungeonId + " not found.");
                    return;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error checking dungeon existence: ", e);
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Error checking dungeon existence.");
                return;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Initiating collapse of dungeon #" + dungeonId + "...");
        dungeonManager.collapseDungeon(dungeonId);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Dungeon #" + dungeonId + " is now collapsing.");
    }

    private void forceScan(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Initiating full world scan...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.plugin.getDungeonManager().scanAroundPlayer(player);
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "World scan completed!");
        });
    }

    private void listPendingLocations(CommandSender sender) {
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM pending_locations ORDER BY discovered_at");){
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No pending dungeon generation locations found.");
                return;
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "===== Pending Dungeon Locations =====");
            int count = 0;
            do {
                int id = rs.getInt("id");
                String worldName = rs.getString("world_name");
                String biomeType = rs.getString("biome_type");
                int x = rs.getInt("x_coord");
                int z = rs.getInt("z_coord");
                String discoveredAt = rs.getTimestamp("discovered_at").toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "ID: " + String.valueOf(ChatColor.WHITE) + id + " | " + String.valueOf(ChatColor.YELLOW) + "World: " + String.valueOf(ChatColor.WHITE) + worldName + " | " + String.valueOf(ChatColor.YELLOW) + "Biome: " + String.valueOf(ChatColor.WHITE) + biomeType + " | " + String.valueOf(ChatColor.YELLOW) + "Location: " + String.valueOf(ChatColor.WHITE) + x + ", ?, " + z + " | " + String.valueOf(ChatColor.YELLOW) + "Discovered: " + String.valueOf(ChatColor.WHITE) + discoveredAt);
                if (++count < 10) continue;
                int remaining = 0;
                while (rs.next()) {
                    ++remaining;
                }
                if (remaining > 0) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "... and " + remaining + " more locations.");
                }
                break;
            } while (rs.next());
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error listing pending locations: ", e);
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Error listing pending locations.");
        }
    }
}

