/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.config;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.config.ConfigMigrator;
import com.ubivismedia.aidungeon.config.ConfigUpgrader;
import java.io.File;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final AIDungeon plugin;
    private FileConfiguration config;
    private ConfigUpgrader configUpgrader;
    private String dbType;
    private String dbHost;
    private int dbPort;
    private String dbName;
    private String dbUser;
    private String dbPassword;
    private String dbFile;
    private int periodicCheckMinutes;
    private LocalTime dailyScanTime;
    private int minDistanceBetweenDungeons;
    private int playerSightRange;
    private double dungeonSpawnChance;
    private int maxDungeonsPerRegion;
    private int maxRoomsPerDungeon;
    private String geminiApiKey;
    private String geminiModel;
    private String geminiPeakHoursModel;
    private String geminiOffPeakModel;
    private LocalTime geminiPeakHoursStart;
    private LocalTime geminiPeakHoursEnd;
    private String geminiLanguage;
    private int geminiTimeout;
    private boolean apiReportingEnabled;
    private String apiReportingBaseUrl;
    private int apiReportingFrequency;
    private int apiReportingBatchSize;
    private int apiReportingResendCooldown;

    public ConfigManager(AIDungeon plugin) {
        this.plugin = plugin;
    }

    public boolean loadConfiguration() {
        try {
            Map<String, String> validationIssues;
            File configFile = new File(this.plugin.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                this.plugin.saveDefaultConfig();
            }
            this.plugin.reloadConfig();
            this.config = this.plugin.getConfig();
            ConfigMigrator configMigrator = new ConfigMigrator(this.plugin);
            boolean wasMigrated = configMigrator.migrateConfig();
            if (wasMigrated) {
                this.plugin.reloadConfig();
                this.config = this.plugin.getConfig();
            }
            this.configUpgrader = new ConfigUpgrader(this.plugin);
            boolean wasUpgraded = this.configUpgrader.upgradeConfig();
            if (wasUpgraded) {
                this.plugin.reloadConfig();
                this.config = this.plugin.getConfig();
            }
            if (!(validationIssues = this.configUpgrader.validateConfig()).isEmpty()) {
                for (Map.Entry<String, String> issue : validationIssues.entrySet()) {
                    this.plugin.getLogger().warning("Config validation issue: " + issue.getKey() + " - " + issue.getValue());
                }
            }
            this.dbType = this.config.getString("database.type", "sqlite");
            this.dbHost = this.config.getString("database.host", "localhost");
            this.dbPort = this.config.getInt("database.port", 3306);
            this.dbName = this.config.getString("database.name", "aidungeon");
            this.dbUser = this.config.getString("database.user", "root");
            this.dbPassword = this.config.getString("database.password", "");
            this.dbFile = this.config.getString("database.file", "aidungeon.db");
            this.periodicCheckMinutes = this.config.getInt("scheduler.periodicCheckMinutes", 10);
            String timeString = this.config.getString("scheduler.dailyScanTime", "03:00");
            try {
                this.dailyScanTime = LocalTime.parse(timeString, DateTimeFormatter.ofPattern("HH:mm"));
            }
            catch (DateTimeParseException e) {
                this.plugin.getLogger().warning("Invalid dailyScanTime format in config. Using default (03:00).");
                this.dailyScanTime = LocalTime.of(3, 0);
            }
            this.minDistanceBetweenDungeons = this.config.getInt("generation.minDistanceBetweenDungeons", 500);
            this.playerSightRange = this.config.getInt("generation.playerSightRange", 100);
            this.dungeonSpawnChance = this.config.getDouble("generation.dungeonSpawnChance", 0.2);
            this.maxDungeonsPerRegion = this.config.getInt("generation.maxDungeonsPerRegion", 3);
            this.maxRoomsPerDungeon = this.config.getInt("generation.maxRoomsPerDungeon", 15);
            this.geminiApiKey = this.config.getString("gemini.apiKey", "");
            this.geminiModel = this.config.getString("gemini.model", "gemini-1.5-pro");
            this.geminiPeakHoursModel = this.config.getString("gemini.peakHoursModel", "gemini-1.5-flash");
            this.geminiOffPeakModel = this.config.getString("gemini.offPeakModel", "gemini-1.5-pro");
            this.geminiLanguage = this.config.getString("gemini.language", "");
            this.geminiTimeout = this.config.getInt("gemini.timeoutSeconds", 30);
            String peakStartStr = this.config.getString("gemini.peakHoursStart", "16:00");
            String peakEndStr = this.config.getString("gemini.peakHoursEnd", "22:00");
            try {
                this.geminiPeakHoursStart = LocalTime.parse(peakStartStr, DateTimeFormatter.ofPattern("HH:mm"));
            }
            catch (DateTimeParseException e) {
                this.plugin.getLogger().warning("Invalid peakHoursStart format in config. Using default (16:00).");
                this.geminiPeakHoursStart = LocalTime.of(16, 0);
            }
            try {
                this.geminiPeakHoursEnd = LocalTime.parse(peakEndStr, DateTimeFormatter.ofPattern("HH:mm"));
            }
            catch (DateTimeParseException e) {
                this.plugin.getLogger().warning("Invalid peakHoursEnd format in config. Using default (22:00).");
                this.geminiPeakHoursEnd = LocalTime.of(22, 0);
            }
            if (this.config.contains("api_reporting")) {
                this.apiReportingEnabled = this.config.getBoolean("api_reporting.enabled", false);
                this.apiReportingBaseUrl = this.config.getString("api_reporting.base_url", "https://api.ubivismedia.com/api/index.php");
                this.apiReportingFrequency = this.config.getInt("api_reporting.report_frequency", 60);
                this.apiReportingBatchSize = this.config.getInt("api_reporting.batch_size", 10);
                this.apiReportingResendCooldown = this.config.getInt("api_reporting.resend_cooldown", 72);
            } else {
                this.apiReportingEnabled = false;
                this.apiReportingBaseUrl = "https://api.ubivismedia.com/api/index.php";
                this.apiReportingFrequency = 60;
                this.apiReportingBatchSize = 10;
                this.apiReportingResendCooldown = 72;
            }
            if (this.periodicCheckMinutes < 1) {
                this.plugin.getLogger().warning("periodicCheckMinutes must be at least 1. Setting to default (10).");
                this.periodicCheckMinutes = 10;
            }
            if (this.geminiApiKey.isEmpty()) {
                this.plugin.getLogger().warning("No Gemini API key provided. AI dungeon generation will not work without a valid API key.");
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load configuration: ", e);
            return false;
        }
    }

    public void saveConfiguration() {
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save configuration: ", e);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean isWithinPeakHours() {
        LocalTime now = LocalTime.now();
        if (this.geminiPeakHoursStart.isAfter(this.geminiPeakHoursEnd)) {
            return !now.isBefore(this.geminiPeakHoursStart) || !now.isAfter(this.geminiPeakHoursEnd);
        }
        return !now.isBefore(this.geminiPeakHoursStart) && !now.isAfter(this.geminiPeakHoursEnd);
    }

    public String getCurrentGeminiModel() {
        if (this.geminiPeakHoursModel.equals(this.geminiOffPeakModel)) {
            return this.geminiModel;
        }
        if (this.isWithinPeakHours()) {
            return this.geminiPeakHoursModel;
        }
        return this.geminiOffPeakModel;
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public int getDbPort() {
        return this.dbPort;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbFile() {
        return this.dbFile;
    }

    public int getPeriodicCheckMinutes() {
        return this.periodicCheckMinutes;
    }

    public LocalTime getDailyScanTime() {
        return this.dailyScanTime;
    }

    public int getMinDistanceBetweenDungeons() {
        return this.minDistanceBetweenDungeons;
    }

    public int getPlayerSightRange() {
        return this.playerSightRange;
    }

    public double getDungeonSpawnChance() {
        return this.dungeonSpawnChance;
    }

    public int getMaxDungeonsPerRegion() {
        return this.maxDungeonsPerRegion;
    }

    public int getMaxRoomsPerDungeon() {
        return this.maxRoomsPerDungeon;
    }

    public String getGeminiApiKey() {
        return this.geminiApiKey;
    }

    public String getGeminiModel() {
        return this.geminiModel;
    }

    public String getGeminiPeakHoursModel() {
        return this.geminiPeakHoursModel;
    }

    public String getGeminiOffPeakModel() {
        return this.geminiOffPeakModel;
    }

    public LocalTime getGeminiPeakHoursStart() {
        return this.geminiPeakHoursStart;
    }

    public LocalTime getGeminiPeakHoursEnd() {
        return this.geminiPeakHoursEnd;
    }

    public String getGeminiLanguage() {
        return this.geminiLanguage;
    }

    public int getGeminiTimeout() {
        return this.geminiTimeout;
    }

    public boolean isApiReportingEnabled() {
        return this.apiReportingEnabled;
    }

    public String getApiReportingBaseUrl() {
        return this.apiReportingBaseUrl;
    }

    public int getApiReportingFrequency() {
        return this.apiReportingFrequency;
    }

    public int getApiReportingBatchSize() {
        return this.apiReportingBatchSize;
    }

    public int getApiReportingResendCooldown() {
        return this.apiReportingResendCooldown;
    }
}

